/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.event;

import com.mcmoddev.golems.EGRegistry;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.block.GolemHeadBlock;
import com.mcmoddev.golems.container.GolemContainer;
import com.mcmoddev.golems.container.behavior.GolemBehaviors;
import com.mcmoddev.golems.container.render.GolemRenderSettings;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.network.SGolemContainerPacket;
import com.mcmoddev.golems.network.SGolemModelPacket;
import com.mcmoddev.golems.network.SummonGolemCommand;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.sensing.GolemSensor;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class EGForgeEvents {
    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener(ExtraGolems.GOLEM_CONTAINERS);
        event.addListener(ExtraGolems.GOLEM_RENDER_SETTINGS);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ExtraGolems.GOLEM_CONTAINERS.getEntries().forEach(e -> ((Optional)e.getValue()).ifPresent(c -> ExtraGolems.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SGolemContainerPacket((ResourceLocation)e.getKey(), (GolemContainer)c))));
            ExtraGolems.GOLEM_RENDER_SETTINGS.getEntries().forEach(e -> ((Optional)e.getValue()).ifPresent(c -> ExtraGolems.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SGolemModelPacket((ResourceLocation)e.getKey(), (GolemRenderSettings)c))));
        }
    }

    @SubscribeEvent
    public static void onAddCommands(RegisterCommandsEvent event) {
        SummonGolemCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onPlacePumpkin(BlockEvent.EntityPlaceEvent event) {
        if (!event.isCanceled() && ExtraGolems.CONFIG.pumpkinBuildsGolems() && event.getPlacedBlock().m_60734_() == Blocks.f_50143_ && event.getLevel() instanceof Level) {
            GolemHeadBlock.trySpawnGolem(event.getEntity(), (Level)event.getLevel(), event.getPos());
        }
    }

    @SubscribeEvent
    public static void onTargetEvent(LivingSetAttackTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob) {
            GolemBase target;
            Mob mob = (Mob)livingEntity;
            livingEntity = event.getTarget();
            if (livingEntity instanceof GolemBase && (target = (GolemBase)livingEntity).getContainer().hasBehavior(GolemBehaviors.USE_FUEL) && !target.hasFuel()) {
                mob.m_6710_(null);
                mob.m_6703_(null);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        Level level;
        if (event.getEntity().m_6142_() && (level = event.getEntity().f_19853_) instanceof ServerLevel) {
            Optional entity;
            AABB aabb;
            List<Villager> nearbyVillagers;
            Villager villager;
            ServerLevel serverLevel = (ServerLevel)level;
            if (ExtraGolems.CONFIG.villagerSummonChance() > 0 && (level = event.getEntity()) instanceof Villager && !(villager = (Villager)level).m_5803_() && (long)villager.f_19797_ % 90L == 0L && villager.m_35392_((long)villager.f_19797_) && villager.m_217043_().m_188503_(100) < ExtraGolems.CONFIG.villagerSummonChance() && (nearbyVillagers = serverLevel.m_45976_(Villager.class, aabb = villager.m_20191_().m_82377_(10.0, 10.0, 10.0)).stream().filter(e -> e.m_35392_((long)villager.f_19797_)).limit(5L).toList()).size() >= 3 && (entity = SpawnUtil.m_216403_((EntityType)((EntityType)EGRegistry.GOLEM.get()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (ServerLevel)serverLevel, (BlockPos)villager.m_20183_(), (int)10, (int)8, (int)6, (SpawnUtil.Strategy)SpawnUtil.Strategy.f_216412_)).isPresent()) {
                GolemBase golem = (GolemBase)entity.get();
                ResourceLocation material = EGForgeEvents.getGolemToSpawn(villager.m_20183_(), villager.m_217043_());
                golem.setMaterial(material);
                if (golem.getTextureCount() > 0) {
                    golem.randomizeTexture((Level)serverLevel, villager.m_20183_());
                }
                golem.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(villager.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                nearbyVillagers.forEach(GolemSensor::m_26649_);
            }
        }
    }

    private static ResourceLocation getGolemToSpawn(BlockPos pos, RandomSource random) {
        List<ResourceLocation> options = ExtraGolems.CONFIG.getVillagerGolems();
        ResourceLocation choice = options.isEmpty() ? GolemContainer.EMPTY_MATERIAL : options.get(random.m_188503_(options.size()));
        return choice;
    }
}

