/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.event;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.event.AoeFunction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public final class GolemModifyBlocksEvent
extends Event {
    private List<BlockPos> affectedBlocks;
    private AoeFunction function;
    public final GolemBase entity;
    public final BlockPos center;
    public final int range;
    public final boolean sphere;
    public int updateFlag;

    public GolemModifyBlocksEvent(GolemBase golem, BlockPos center, int radius, boolean sphere, AoeFunction function) {
        this.setResult(Event.Result.ALLOW);
        this.entity = golem;
        this.center = center;
        this.range = Math.min(radius, 16);
        this.sphere = sphere;
        this.updateFlag = 3;
        this.setFunction(function, true);
    }

    public void initAffectedBlockList(int range) {
        this.affectedBlocks = new ArrayList<BlockPos>(range * range * 2 * 4);
        int maxDis = range * range;
        int dY = this.sphere ? range : 1;
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        for (int i = -range; i <= range; ++i) {
            for (int j = -dY; j <= dY; ++j) {
                for (int k = -range; k <= range; ++k) {
                    BlockState state;
                    BlockState replace;
                    currentPos.m_122154_((Vec3i)this.center, i, j, k);
                    if (!(this.center.m_123331_((Vec3i)currentPos) <= (double)maxDis) || (replace = this.function.map((LivingEntity)this.entity, (BlockPos)currentPos, state = this.entity.f_19853_.m_8055_((BlockPos)currentPos))) == state) continue;
                    this.affectedBlocks.add(currentPos.m_7949_());
                }
            }
        }
    }

    public AoeFunction getFunction() {
        return this.function;
    }

    public void setFunction(AoeFunction toSet, boolean refresh) {
        this.function = toSet;
        if (refresh) {
            this.initAffectedBlockList(this.range);
        }
    }

    public List<BlockPos> getAffectedPositions() {
        return this.affectedBlocks;
    }

    public boolean add(BlockPos pos) {
        return this.affectedBlocks.add(pos);
    }

    public boolean remove(BlockPos toRemove) {
        return this.affectedBlocks.remove(toRemove);
    }
}

