/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.integration;

import com.mcmoddev.golems.container.behavior.GolemBehaviors;
import com.mcmoddev.golems.entity.GolemBase;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attributes;

public abstract class GolemDescriptionManager {
    protected boolean showSpecial = true;
    protected boolean showSpecialChild = false;
    protected boolean showAttack = true;
    protected boolean extended = false;

    public List<Component> getEntityDescription(GolemBase golem) {
        LinkedList<Component> list = new LinkedList<Component>();
        if (this.showAttack) {
            double attack = golem.m_21051_(Attributes.f_22281_).m_22135_();
            list.add((Component)Component.m_237115_((String)"entitytip.attack").m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)Double.toString(attack)).m_130940_(ChatFormatting.WHITE)));
        }
        if (this.showSpecial) {
            if (golem.getContainer().hasBehavior(GolemBehaviors.USE_FUEL)) {
                this.addFuelInfo(golem, list);
            }
            if (golem.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS)) {
                this.addArrowsInfo(golem, list);
            }
        }
        if (!golem.m_6162_() && this.showSpecial || golem.m_6162_() && this.showSpecialChild) {
            list.addAll((Collection<Component>)golem.getContainer().getDescriptions());
        }
        return list;
    }

    protected void addFuelInfo(GolemBase g, List<Component> list) {
        float percentFuel = g.getFuelPercentage() * 100.0f;
        ChatFormatting color = percentFuel < 6.0f ? ChatFormatting.RED : (percentFuel < 16.0f ? ChatFormatting.YELLOW : ChatFormatting.WHITE);
        Object fuelString = this.extended ? String.format("%d / %d", g.getFuel(), g.getMaxFuel()) : String.format("%.1f", Float.valueOf(percentFuel)) + "%";
        list.add((Component)Component.m_237115_((String)"entitytip.fuel").m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)fuelString).m_130940_(color)));
    }

    protected void addArrowsInfo(GolemBase g, List<Component> list) {
        int arrows = g.getArrowsInInventory();
        if (arrows > 0 && this.extended) {
            ChatFormatting color = ChatFormatting.WHITE;
            String arrowString = String.valueOf(arrows);
            list.add((Component)Component.m_237115_((String)"entitytip.arrows").m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)arrowString).m_130940_(color)));
        }
    }

    protected static boolean isShiftDown() {
        return Screen.m_96638_();
    }
}

