/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.network;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.render.GolemRenderSettings;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SGolemModelPacket {
    protected ResourceLocation key;
    protected GolemRenderSettings golemModel;

    public SGolemModelPacket(ResourceLocation key, GolemRenderSettings golemModelIn) {
        this.key = key;
        this.golemModel = golemModelIn;
    }

    public static SGolemModelPacket fromBytes(FriendlyByteBuf buf) {
        ResourceLocation sKey = buf.m_130281_();
        CompoundTag sNBT = buf.m_130260_();
        Optional sCont = ExtraGolems.GOLEM_RENDER_SETTINGS.readObject((Tag)sNBT).resultOrPartial(error -> ExtraGolems.LOGGER.error("Failed to read GolemRenderSettings from NBT for packet\n" + error));
        return new SGolemModelPacket(sKey, sCont.orElse(GolemRenderSettings.EMPTY));
    }

    public static void toBytes(SGolemModelPacket msg, FriendlyByteBuf buf) {
        DataResult<Tag> nbtResult = ExtraGolems.GOLEM_RENDER_SETTINGS.writeObject(msg.golemModel);
        Tag tag = (Tag)nbtResult.resultOrPartial(error -> ExtraGolems.LOGGER.error("Failed to write GolemRenderSettings to NBT for packet\n" + error)).get();
        buf.m_130085_(msg.key);
        buf.m_130079_((CompoundTag)tag);
    }

    public static void handlePacket(SGolemModelPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                ExtraGolems.GOLEM_RENDER_SETTINGS.put(message.key, message.golemModel);
                message.golemModel.load();
            });
        }
        context.setPacketHandled(true);
    }
}

