/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.screen;

import com.mcmoddev.golems.container.GolemContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class GolemBookEntry {
    private final Block[] buildingBlocks;
    private final String nameString;
    private ResourceLocation imageLoc = null;
    private final int health;
    private final float attack;
    private final MutableComponent name;
    private final MutableComponent page;
    private final List<Component> specials = new ArrayList<Component>();

    public GolemBookEntry(@Nonnull ResourceLocation golemName, @Nonnull GolemContainer container) {
        this.nameString = "entity." + golemName.m_135827_() + ".golem." + golemName.m_135815_();
        this.health = (int)container.getAttributes().getHealth();
        this.attack = (float)container.getAttributes().getAttack();
        this.specials.addAll((Collection<Component>)container.getDescriptions());
        this.buildingBlocks = container.getAllBlocks().toArray(new Block[0]);
        String modid = golemName.m_135827_();
        String name = golemName.m_135815_();
        ResourceLocation img = new ResourceLocation(modid, "textures/gui/info_book/".concat(name).concat(".png"));
        Optional imageResource = Minecraft.m_91087_().m_91098_().m_213713_(img);
        this.imageLoc = imageResource.isPresent() ? img : null;
        this.name = Component.m_237115_((String)this.nameString);
        this.page = this.makePage();
    }

    public String getGolemNameRaw() {
        return this.nameString;
    }

    public boolean hasBlocks() {
        return this.buildingBlocks != null && this.buildingBlocks.length > 0;
    }

    public Block getBlock(int index) {
        return this.hasBlocks() ? this.buildingBlocks[index % this.buildingBlocks.length] : Blocks.f_50016_;
    }

    public Block[] getBlocks() {
        return this.buildingBlocks;
    }

    public float getAttack() {
        return this.attack;
    }

    public int getDescriptionSize() {
        return this.specials.size();
    }

    public MutableComponent getGolemName() {
        return this.name;
    }

    public MutableComponent getDescriptionPage() {
        return this.page;
    }

    public boolean hasImage() {
        return this.imageLoc != null;
    }

    @Nullable
    public ResourceLocation getImageResource() {
        return this.imageLoc;
    }

    private MutableComponent makePage() {
        MutableComponent page = Component.m_237113_((String)"");
        page.m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"entitytip.health").m_130946_(": ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)String.valueOf(this.health)).m_130940_(ChatFormatting.BLACK)).m_7220_((Component)Component.m_237113_((String)" \u2764").m_130940_(ChatFormatting.DARK_RED));
        page.m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"entitytip.attack").m_130946_(": ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)String.valueOf(this.attack)).m_130940_(ChatFormatting.BLACK)).m_130946_(" \u2694").m_130946_("\n");
        for (Component s : this.specials) {
            page.m_130946_("\n").m_7220_(s);
        }
        return page;
    }
}

