/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems;

import com.mcmoddev.golems.EGRegistry;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.block.GolemHeadBlock;
import com.mcmoddev.golems.container.GolemContainer;
import com.mcmoddev.golems.container.behavior.GolemBehaviors;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.network.SummonGolemCommand;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.GolemSensor;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class EGEvents {
    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register(ModHandler.class);
        MinecraftForge.EVENT_BUS.register(ForgeHandler.class);
    }

    public static class ModHandler {
    }

    public static class ForgeHandler {
        private static final TagKey<GolemContainer> VILLAGER_SUMMONABLE = TagKey.m_203882_(ExtraGolems.Keys.GOLEM_CONTAINERS, (ResourceLocation)new ResourceLocation("golems", "villager_summonable"));

        @SubscribeEvent
        public static void onAddCommands(RegisterCommandsEvent event) {
            SummonGolemCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        public static void onPlacePumpkin(BlockEvent.EntityPlaceEvent event) {
            if (!event.isCanceled() && ExtraGolems.CONFIG.pumpkinBuildsGolems() && event.getPlacedBlock().m_60734_() == Blocks.f_50143_ && event.getLevel() instanceof Level) {
                GolemHeadBlock.trySpawnGolem(event.getEntity(), (Level)event.getLevel(), event.getPos());
            }
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            GolemBase golem;
            Entity entity;
            if (event.getEntity() instanceof AbstractVillager && event.getSource().m_19360_() && (entity = event.getSource().m_7639_()) instanceof GolemBase && (golem = (GolemBase)entity).getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onTargetEvent(LivingChangeTargetEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Mob) {
                GolemBase target;
                Mob mob = (Mob)livingEntity;
                livingEntity = event.getNewTarget();
                if (livingEntity instanceof GolemBase && (target = (GolemBase)livingEntity).getContainer().hasBehavior(GolemBehaviors.USE_FUEL) && !target.hasFuel()) {
                    mob.m_6710_(null);
                    mob.m_6703_(null);
                }
            }
        }

        @SubscribeEvent
        public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
            Level level;
            if (event.getEntity().m_6142_() && (level = event.getEntity().f_19853_) instanceof ServerLevel) {
                Optional entity;
                AABB aabb;
                List<Villager> nearbyVillagers;
                Villager villager;
                ServerLevel serverLevel = (ServerLevel)level;
                if (ExtraGolems.CONFIG.villagerSummonChance() > 0 && (level = event.getEntity()) instanceof Villager && !(villager = (Villager)level).m_5803_() && (long)villager.f_19797_ % 90L == 0L && !ForgeHandler.checkForNearbyGolem((LivingEntity)villager) && villager.m_35392_((long)villager.f_19797_) && villager.m_217043_().m_188503_(100) < ExtraGolems.CONFIG.villagerSummonChance() && (nearbyVillagers = serverLevel.m_45976_(Villager.class, aabb = villager.m_20191_().m_82377_(10.0, 10.0, 10.0)).stream().filter(e -> e.m_35392_((long)villager.f_19797_)).limit(5L).toList()).size() >= 3 && (entity = SpawnUtil.m_216403_((EntityType)((EntityType)EGRegistry.GOLEM.get()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (ServerLevel)serverLevel, (BlockPos)villager.m_20183_(), (int)10, (int)8, (int)6, (SpawnUtil.Strategy)SpawnUtil.Strategy.f_216412_)).isPresent()) {
                    GolemBase golem = (GolemBase)entity.get();
                    ResourceLocation material = ForgeHandler.getGolemToSpawn(villager.m_9236_(), villager.m_20183_(), villager.m_217043_());
                    if (null == material) {
                        golem.m_146870_();
                        return;
                    }
                    golem.setMaterial(material);
                    if (golem.getTextureCount() > 0) {
                        golem.randomizeTexture((Level)serverLevel, villager.m_20183_());
                    }
                    golem.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(villager.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    nearbyVillagers.forEach(GolemSensor::m_26649_);
                }
            }
        }

        private static ResourceLocation getGolemToSpawn(Level level, BlockPos pos, RandomSource random) {
            Registry registry = level.m_5962_().m_175515_(ExtraGolems.Keys.GOLEM_CONTAINERS);
            Optional oHolder = registry.m_203561_(VILLAGER_SUMMONABLE).m_213653_(random);
            GolemContainer container = (GolemContainer)oHolder.orElse(Holder.m_205709_((Object)GolemContainer.EMPTY)).get();
            return registry.m_7981_((Object)container);
        }

        private static boolean checkForNearbyGolem(LivingEntity villager) {
            boolean flag;
            Optional optional = villager.m_6274_().m_21952_(MemoryModuleType.f_148204_);
            if (optional.isPresent() && (flag = ((List)optional.get()).stream().anyMatch(e -> e instanceof IronGolem))) {
                GolemSensor.m_26649_((LivingEntity)villager);
                return true;
            }
            return false;
        }
    }
}

