/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems;

import com.mcmoddev.golems.EGClientEvents;
import com.mcmoddev.golems.EGConfig;
import com.mcmoddev.golems.EGEvents;
import com.mcmoddev.golems.EGRegistry;
import com.mcmoddev.golems.block.GolemHeadBlock;
import com.mcmoddev.golems.container.GolemContainer;
import com.mcmoddev.golems.container.behavior.GolemBehaviors;
import com.mcmoddev.golems.container.render.GolemRenderSettings;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.integration.AddonLoader;
import com.mcmoddev.golems.integration.TOPDescriptionManager;
import com.mcmoddev.golems.item.GolemSpellItem;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="golems")
public class ExtraGolems {
    public static final String MODID = "golems";
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"golems");
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final EGConfig CONFIG = new EGConfig(BUILDER);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    private static final String PROTOCOL_VERSION = "3";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("golems", "channel"), () -> "3", "3"::equals, "3"::equals);
    public static final DeferredRegister<GolemContainer> GOLEM_CONTAINERS = DeferredRegister.create(Keys.GOLEM_CONTAINERS, (String)"golems");
    private static final Supplier<IForgeRegistry<GolemContainer>> GOLEM_CONTAINERS_SUPPLIER = GOLEM_CONTAINERS.makeRegistry(() -> new RegistryBuilder().dataPackRegistry(GolemContainer.CODEC, GolemContainer.CODEC).hasTags());
    public static final DeferredRegister<GolemRenderSettings> GOLEM_MODELS = DeferredRegister.create(Keys.GOLEM_MODELS, (String)"golems");
    private static final Supplier<IForgeRegistry<GolemRenderSettings>> GOLEM_MODELS_SUPPLIER = GOLEM_MODELS.makeRegistry(() -> new RegistryBuilder().dataPackRegistry(GolemRenderSettings.CODEC, GolemRenderSettings.CODEC).onClear((owner, stage) -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> EGClientEvents.onClearGolemModels())));

    public ExtraGolems() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ExtraGolems::loadConfig);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ExtraGolems::reloadConfig);
        EGRegistry.init();
        GolemBehaviors.init();
        EGEvents.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(AddonLoader::onAddPackFinders);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> EGClientEvents::register);
        boolean messageId = false;
    }

    private void setup(FMLCommonSetupEvent event) {
        AddonLoader.init();
        GolemSpellItem.registerDispenserBehavior();
        GolemHeadBlock.registerDispenserBehavior();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            LOGGER.info("Extra Golems detected TheOneProbe, registering plugin now");
            InterModComms.sendTo((String)MODID, (String)"theoneprobe", (String)"getTheOneProbe", () -> new TOPDescriptionManager.GetTheOneProbe());
        }
    }

    public static void loadConfig(ModConfigEvent.Loading event) {
        CONFIG.bake();
    }

    public static void reloadConfig(ModConfigEvent.Reloading event) {
        CONFIG.bake();
    }

    @Nullable
    public static GolemBase getGolem(Level level, Block bodyBlock, Block bodySupportBlock, Block leftArmBlock, Block rightArmBlock) {
        ResourceLocation id = ExtraGolems.getGolemId(level, bodyBlock, bodySupportBlock, leftArmBlock, rightArmBlock);
        if (null == id) {
            return null;
        }
        return GolemBase.create(level, id);
    }

    @Nullable
    public static ResourceLocation getGolemId(Level level, Block bodyBlock, Block bodySupportBlock, Block leftArmBlock, Block rightArmBlock) {
        ResourceLocation id = null;
        Registry registry = level.m_5962_().m_175515_(Keys.GOLEM_CONTAINERS);
        for (Map.Entry entry : registry.m_6579_()) {
            if (!((GolemContainer)entry.getValue()).matches(bodyBlock, bodySupportBlock, leftArmBlock, rightArmBlock)) continue;
            id = ((ResourceKey)entry.getKey()).m_135782_();
            break;
        }
        return id;
    }

    public static class Keys {
        public static final ResourceKey<Registry<GolemContainer>> GOLEM_CONTAINERS = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("golems", "golem_stats"));
        public static final ResourceKey<Registry<GolemRenderSettings>> GOLEM_MODELS = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("golems", "golem_models"));
    }
}

