/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.block;

import com.mcmoddev.golems.EGRegistry;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.entity.GolemBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;

public final class GolemHeadBlock
extends HorizontalDirectionalBlock {
    public GolemHeadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public PushReaction m_5537_(BlockState blockState) {
        return PushReaction.NORMAL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState oldState, boolean isMoving) {
        super.m_6807_(blockState, level, blockPos, oldState, isMoving);
        GolemHeadBlock.trySpawnGolem(null, level, blockPos);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        GolemHeadBlock.trySpawnGolem((Entity)placer, level, pos);
    }

    public static void registerDispenserBehavior() {
        final DispenseItemBehavior carvedPumpkinBehavior = (DispenseItemBehavior)DispenserBlock.f_52661_.getOrDefault(Items.f_42047_, new DefaultDispenseItemBehavior());
        OptionalDispenseItemBehavior wrappedBehavior = new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource blockSource, ItemStack itemStack) {
                ServerLevel level = blockSource.m_7727_();
                Direction facing = (Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos blockpos = blockSource.m_7961_().m_121945_(facing);
                if (level.m_46859_(blockpos) && GolemHeadBlock.canSpawnGolem((Level)level, blockpos)) {
                    if (!level.f_46443_) {
                        level.m_7731_(blockpos, (BlockState)((Block)EGRegistry.GOLEM_HEAD.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)facing), 3);
                        level.m_142346_(null, GameEvent.f_157797_, blockpos);
                    }
                    itemStack.m_41774_(1);
                    this.m_123573_(true);
                }
                if (itemStack.m_150930_(Items.f_42047_) || ExtraGolems.CONFIG.pumpkinBuildsGolems()) {
                    return carvedPumpkinBehavior.m_6115_(blockSource, itemStack);
                }
                return itemStack;
            }
        };
        DispenserBlock.m_52672_((ItemLike)((ItemLike)EGRegistry.GOLEM_HEAD_ITEM.get()), (DispenseItemBehavior)wrappedBehavior);
        DispenserBlock.m_52672_((ItemLike)Items.f_42047_, (DispenseItemBehavior)wrappedBehavior);
    }

    public static boolean canSpawnGolem(Level level, BlockPos headPos) {
        Block blockBelow1 = level.m_8055_(headPos.m_6625_(1)).m_60734_();
        Block blockBelow2 = level.m_8055_(headPos.m_6625_(2)).m_60734_();
        Block blockArmNorth = level.m_8055_(headPos.m_6625_(1).m_122013_(1)).m_60734_();
        Block blockArmSouth = level.m_8055_(headPos.m_6625_(1).m_122020_(1)).m_60734_();
        Block blockArmEast = level.m_8055_(headPos.m_6625_(1).m_122030_(1)).m_60734_();
        Block blockArmWest = level.m_8055_(headPos.m_6625_(1).m_122025_(1)).m_60734_();
        if (GolemHeadBlock.doBlocksMatch(Blocks.f_50127_, blockBelow1, blockBelow2)) {
            return true;
        }
        boolean isIron = GolemHeadBlock.doBlocksMatch(Blocks.f_50075_, blockBelow1, blockBelow2, blockArmNorth, blockArmSouth);
        if (!isIron) {
            isIron = GolemHeadBlock.doBlocksMatch(Blocks.f_50075_, blockBelow1, blockBelow2, blockArmEast, blockArmWest);
        }
        if (isIron) {
            return true;
        }
        if (GolemHeadBlock.isInvalidBlock(blockBelow1) || GolemHeadBlock.isInvalidBlock(blockBelow2)) {
            return false;
        }
        ResourceLocation golemId = ExtraGolems.getGolemId(level, blockBelow1, blockBelow2, blockArmNorth, blockArmSouth);
        if (golemId == null) {
            golemId = ExtraGolems.getGolemId(level, blockBelow1, blockBelow2, blockArmEast, blockArmWest);
        }
        return golemId != null;
    }

    public static boolean trySpawnGolem(@Nullable Entity placer, Level level, BlockPos headPos) {
        BlockState stateBelow1 = level.m_8055_(headPos.m_6625_(1));
        BlockState stateBelow2 = level.m_8055_(headPos.m_6625_(2));
        BlockState stateArmNorth = level.m_8055_(headPos.m_6625_(1).m_122013_(1));
        BlockState stateArmSouth = level.m_8055_(headPos.m_6625_(1).m_122020_(1));
        BlockState stateArmEast = level.m_8055_(headPos.m_6625_(1).m_122030_(1));
        BlockState stateArmWest = level.m_8055_(headPos.m_6625_(1).m_122025_(1));
        Block blockBelow1 = stateBelow1.m_60734_();
        Block blockBelow2 = stateBelow2.m_60734_();
        Block blockArmNorth = stateArmNorth.m_60734_();
        Block blockArmSouth = stateArmSouth.m_60734_();
        Block blockArmEast = stateArmEast.m_60734_();
        Block blockArmWest = stateArmWest.m_60734_();
        double spawnX = (double)headPos.m_123341_() + 0.5;
        double spawnY = (double)headPos.m_123342_() - 1.95;
        double spawnZ = (double)headPos.m_123343_() + 0.5;
        if (GolemHeadBlock.doBlocksMatch(Blocks.f_50127_, blockBelow1, blockBelow2)) {
            if (!level.m_5776_()) {
                GolemHeadBlock.removeGolemBody(level, headPos);
                SnowGolem entitysnowman = (SnowGolem)EntityType.f_20528_.m_20615_(level);
                entitysnowman.m_7678_(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
                level.m_7967_((Entity)entitysnowman);
            }
            return true;
        }
        boolean isIron = GolemHeadBlock.doBlocksMatch(Blocks.f_50075_, blockBelow1, blockBelow2, blockArmNorth, blockArmSouth);
        boolean isEastWest = false;
        if (!isIron) {
            isIron = GolemHeadBlock.doBlocksMatch(Blocks.f_50075_, blockBelow1, blockBelow2, blockArmEast, blockArmWest);
            isEastWest = true;
        }
        if (isIron) {
            if (!level.m_5776_()) {
                GolemHeadBlock.removeAllGolemBlocks(level, headPos, isEastWest);
                IronGolem ironGolem = (IronGolem)EntityType.f_20460_.m_20615_(level);
                ironGolem.m_28887_(true);
                ironGolem.m_7678_(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
                level.m_7967_((Entity)ironGolem);
            }
            return true;
        }
        if (GolemHeadBlock.isInvalidBlock(blockBelow1) || GolemHeadBlock.isInvalidBlock(blockBelow2)) {
            return false;
        }
        ResourceLocation golemId = ExtraGolems.getGolemId(level, blockBelow1, blockBelow2, blockArmNorth, blockArmSouth);
        isEastWest = false;
        if (golemId == null) {
            golemId = ExtraGolems.getGolemId(level, blockBelow1, blockBelow2, blockArmEast, blockArmWest);
            isEastWest = true;
        }
        if (golemId != null) {
            if (!level.m_5776_()) {
                GolemBase golem = GolemBase.create(level, golemId);
                GolemHeadBlock.removeAllGolemBlocks(level, headPos, isEastWest);
                golem.m_28887_(true);
                golem.m_7678_(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
                level.m_7967_((Entity)golem);
                if (level instanceof ServerLevel) {
                    golem.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(headPos), MobSpawnType.MOB_SUMMONED, null, null);
                }
                if (isEastWest) {
                    golem.onBuilt(stateBelow1, stateBelow2, stateArmEast, stateArmWest);
                } else {
                    golem.onBuilt(stateBelow1, stateBelow2, stateArmNorth, stateArmSouth);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean doBlocksMatch(Block master, Block ... toCheck) {
        boolean success = toCheck != null && toCheck.length > 0;
        for (Block b : toCheck) {
            success &= b == master;
        }
        return success;
    }

    public static void removeAllGolemBlocks(Level world, BlockPos pos, boolean isXAligned) {
        GolemHeadBlock.removeGolemBody(world, pos);
        GolemHeadBlock.removeGolemArms(world, pos, isXAligned);
    }

    public static void removeGolemBody(Level world, BlockPos head) {
        world.m_46961_(head, false);
        world.m_46961_(head.m_6625_(1), false);
        world.m_46961_(head.m_6625_(2), false);
    }

    public static void removeGolemArms(Level world, BlockPos pos, boolean isXAligned) {
        if (isXAligned) {
            world.m_46961_(pos.m_6625_(1).m_122025_(1), false);
            world.m_46961_(pos.m_6625_(1).m_122030_(1), false);
        } else {
            world.m_46961_(pos.m_6625_(1).m_122013_(1), false);
            world.m_46961_(pos.m_6625_(1).m_122020_(1), false);
        }
    }

    private static boolean isInvalidBlock(Block b) {
        return b == null || b == Blocks.f_50016_ || b == Blocks.f_49990_ || b == Blocks.f_49991_;
    }
}

