/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior;

import com.mcmoddev.golems.container.behavior.GolemBehavior;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.ExplodeGoal;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

@Immutable
public class ExplodeBehavior
extends GolemBehavior {
    protected final double range;
    protected final int fuse;
    protected final double chanceOnHurt;
    protected final double chanceOnAttack;

    public ExplodeBehavior(CompoundTag tag) {
        super(tag);
        this.range = tag.m_128459_("range");
        this.fuse = tag.m_128451_("fuse");
        this.chanceOnHurt = tag.m_128459_("chance_on_hurt");
        this.chanceOnAttack = tag.m_128459_("chance_on_attack");
    }

    public int getFuseLen() {
        return this.fuse;
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        entity.f_21345_.m_25352_(0, new ExplodeGoal<GolemBase>(entity, (float)this.range));
    }

    @Override
    public void onHurtTarget(GolemBase entity, Entity target) {
        if (target.m_6060_() || (double)entity.m_217043_().m_188501_() < this.chanceOnAttack) {
            entity.lightFuse();
        }
    }

    @Override
    public void onActuallyHurt(GolemBase entity, DamageSource source, float amount) {
        if (source.m_19384_() || (double)entity.m_217043_().m_188501_() < this.chanceOnHurt) {
            entity.lightFuse();
        }
    }

    @Override
    public void onDie(GolemBase entity, DamageSource source) {
        entity.explode((float)this.range);
    }

    @Override
    public void onMobInteract(GolemBase entity, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!itemstack.m_41619_() && itemstack.m_41720_() == Items.f_42409_) {
            Vec3 pos = entity.m_20182_();
            entity.f_19853_.m_6263_(player, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11942_, entity.m_5720_(), 1.0f, entity.m_217043_().m_188501_() * 0.4f + 0.8f);
            player.m_6674_(hand);
            entity.m_20254_(Math.floorDiv(this.getFuseLen(), 20));
            entity.lightFuse();
            itemstack.m_41622_(1, (LivingEntity)player, c -> c.m_21190_(hand));
        }
    }

    @Override
    public void onWriteData(GolemBase entity, CompoundTag tag) {
        entity.saveFuse(tag);
    }

    @Override
    public void onReadData(GolemBase entity, CompoundTag tag) {
        entity.loadFuse(tag);
    }

    @Override
    public void onAddDescriptions(List<Component> list) {
        list.add((Component)Component.m_237115_((String)"entitytip.explode").m_130940_(ChatFormatting.RED));
    }
}

