/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior;

import com.mcmoddev.golems.container.behavior.GolemBehavior;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.MoveToItemGoal;
import com.mcmoddev.golems.menu.PortableDispenserMenu;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkHooks;

@Immutable
public class ShootArrowsBehavior
extends GolemBehavior {
    protected final double damage;
    protected final AttributeModifier rangeModifier = new AttributeModifier("Ranged attack bonus", 2.0, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public ShootArrowsBehavior(CompoundTag tag) {
        super(tag);
        this.damage = tag.m_128459_("damage");
    }

    public double getDamage() {
        return this.damage;
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        entity.m_21051_(Attributes.f_22277_).m_22125_(this.rangeModifier);
        entity.f_21345_.m_25352_(4, (Goal)new MoveToItemGoal((Mob)entity, 10.0, 30, 1.0));
        entity.m_21553_(true);
    }

    @Override
    public void onActuallyHurt(GolemBase entity, DamageSource source, float amount) {
        if (source instanceof IndirectEntityDamageSource && source.m_7639_() instanceof LivingEntity) {
            entity.m_6710_((LivingEntity)source.m_7639_());
        }
        boolean forceMelee = entity.m_5448_() != null && entity.m_5448_().m_20280_((Entity)entity) < 8.0;
        entity.updateCombatTask(forceMelee);
    }

    @Override
    public void onMobInteract(GolemBase entity, Player player, InteractionHand hand) {
        if (!player.m_6047_() && player instanceof ServerPlayer) {
            if (entity.getPlayerInMenu() != null) {
                entity.getPlayerInMenu().m_6915_();
            }
            entity.setPlayerInMenu(player);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new PortableDispenserMenu.Provider((Container)entity.m_35311_()));
            player.m_6674_(hand);
        }
    }

    @Override
    public void onTick(GolemBase entity) {
        if (null == entity.getPlayerInMenu()) {
            return;
        }
        entity.m_21573_().m_26573_();
        entity.m_21563_().m_148051_((Entity)entity.getPlayerInMenu());
        if (!entity.isPlayerInRangeForMenu(8.0)) {
            entity.getPlayerInMenu().m_6915_();
            entity.setPlayerInMenu(null);
        }
    }

    @Override
    public void onWriteData(GolemBase entity, CompoundTag tag) {
        entity.saveArrowInventory(tag);
    }

    @Override
    public void onReadData(GolemBase entity, CompoundTag tag) {
        entity.loadArrowInventory(tag);
    }

    @Override
    public void onAddDescriptions(List<Component> list) {
        list.add((Component)Component.m_237115_((String)"entitytip.shoot_arrows").m_130940_(ChatFormatting.LIGHT_PURPLE));
        list.add((Component)Component.m_237115_((String)"entitytip.click_refill").m_130940_(ChatFormatting.GRAY));
    }
}

