/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.render.LayerRenderSettings;
import com.mcmoddev.golems.container.render.MultitextureRenderSettings;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.util.ResourcePair;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class GolemRenderSettings {
    public static final ResourceLocation FALLBACK_PREFAB = new ResourceLocation("minecraft", "textures/entity/iron_golem/iron_golem.png");
    public static final ResourceLocation FALLBACK_BLOCK = new ResourceLocation("minecraft", "textures/block/clay.png");
    public static final ResourceLocation BASE_TEMPLATE = new ResourceLocation("golems", "template");
    public static final ResourcePair FALLBACK_TEXTURE = new ResourcePair(FALLBACK_PREFAB, true);
    public static final ResourcePair NOT_LOADED = new ResourcePair(new ResourceLocation("not_loaded"), true);
    public static final GolemRenderSettings EMPTY = new GolemRenderSettings((List<ResourcePair>)ImmutableList.of((Object)new ResourcePair(new ResourceLocation("minecraft", "iron_golem/iron_golem"), true)), BASE_TEMPLATE, Optional.empty(), false, Optional.empty(), false, Optional.empty(), LayerRenderSettings.EMPTY, LayerRenderSettings.EMPTY, (List<LayerRenderSettings>)ImmutableList.of());
    public static final Codec<GolemRenderSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either(ResourcePair.CODEC, (Codec)ResourcePair.CODEC.listOf()).xmap(either -> (List)either.map(ImmutableList::of, Function.identity()), list -> list.size() == 1 ? Either.left((Object)((ResourcePair)list.get(0))) : Either.right((Object)list)).optionalFieldOf("base", (Object)Lists.newArrayList()).forGetter(GolemRenderSettings::getBaseList), (App)ResourceLocation.f_135803_.optionalFieldOf("base_template", (Object)BASE_TEMPLATE).forGetter(GolemRenderSettings::getBaseTemplateRaw), (App)Codec.INT.optionalFieldOf("base_color").forGetter(GolemRenderSettings::getBaseColor), (App)Codec.BOOL.optionalFieldOf("use_biome_color", (Object)false).forGetter(GolemRenderSettings::useBiomeColor), (App)Codec.BOOL.optionalFieldOf("base_light").forGetter(GolemRenderSettings::getBaseLight), (App)Codec.BOOL.optionalFieldOf("translucent", (Object)false).forGetter(GolemRenderSettings::isTranslucent), (App)MultitextureRenderSettings.CODEC.optionalFieldOf("multitexture").forGetter(GolemRenderSettings::getMultitexture), (App)LayerRenderSettings.CODEC.optionalFieldOf("eyes", (Object)LayerRenderSettings.EYES).forGetter(GolemRenderSettings::getEyes), (App)LayerRenderSettings.CODEC.optionalFieldOf("vines", (Object)LayerRenderSettings.VINES).forGetter(GolemRenderSettings::getVines), (App)LayerRenderSettings.CODEC.listOf().optionalFieldOf("layers", (Object)Lists.newArrayList()).forGetter(GolemRenderSettings::getLayers)).apply((Applicative)instance, GolemRenderSettings::new));
    private final List<ResourcePair> baseList;
    private ResourcePair base = NOT_LOADED;
    private final ResourceLocation baseTemplateRaw;
    private ResourceLocation baseTemplate;
    private final Optional<Integer> baseColor;
    private final boolean useBiomeColor;
    private final Optional<Boolean> baseLight;
    private final boolean translucent;
    private final Optional<MultitextureRenderSettings> multitexture;
    private final LayerRenderSettings eyes;
    private final LayerRenderSettings vines;
    private final List<LayerRenderSettings> layers;

    private GolemRenderSettings(List<ResourcePair> baseList, ResourceLocation baseTemplate, Optional<Integer> baseColor, boolean useBiomeColor, Optional<Boolean> baseLight, boolean translucent, Optional<MultitextureRenderSettings> multitexture, LayerRenderSettings eyes, LayerRenderSettings vines, List<LayerRenderSettings> layers) {
        this.baseList = baseList;
        this.baseColor = baseColor;
        this.baseTemplateRaw = baseTemplate;
        this.baseLight = baseLight;
        this.useBiomeColor = useBiomeColor;
        this.translucent = translucent;
        this.multitexture = multitexture;
        this.eyes = eyes;
        this.vines = vines;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(layers);
        if (eyes.isEnabled()) {
            builder.add((Object)eyes);
        }
        if (vines.isEnabled()) {
            builder.add((Object)vines);
        }
        this.layers = builder.build();
        if (this.getBaseList().isEmpty() && !this.getMultitexture().isPresent()) {
            ExtraGolems.LOGGER.warn("Error parsing GolemRenderSettings: Missing either 'base' or 'multitexture', exactly one must be defined");
        }
        if (!this.getBaseList().isEmpty() && this.getMultitexture().isPresent()) {
            ExtraGolems.LOGGER.warn("Found both 'base' and 'multitexture' in GolemRenderSettings. Ignoring 'base'");
        }
    }

    private List<ResourcePair> getBaseList() {
        return this.baseList;
    }

    public ResourcePair getBase() {
        return this.base;
    }

    public Optional<Integer> getBaseColor() {
        return this.baseColor;
    }

    public ResourceLocation getBaseTemplate() {
        return this.baseTemplate;
    }

    public ResourceLocation getBaseTemplateRaw() {
        return this.baseTemplateRaw;
    }

    public Optional<Boolean> getBaseLight() {
        return this.baseLight;
    }

    public boolean useBiomeColor() {
        return this.useBiomeColor;
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    public LayerRenderSettings getEyes() {
        return this.eyes;
    }

    public LayerRenderSettings getVines() {
        return this.vines;
    }

    public List<LayerRenderSettings> getLayers() {
        return this.layers;
    }

    public Optional<MultitextureRenderSettings> getMultitexture() {
        return this.multitexture;
    }

    public ResourcePair getBase(GolemBase entity) {
        if (this.multitexture.isPresent()) {
            return this.multitexture.get().getBaseMap().getOrDefault(entity.getTextureId(), FALLBACK_TEXTURE);
        }
        return this.getBase();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("GolemRenderSettings: ");
        b.append("base[").append(this.base).append("] ");
        b.append("template[").append(this.baseTemplate).append("] ");
        b.append("color[").append(this.baseColor).append("] ");
        b.append("biome_color[").append(this.useBiomeColor).append("] ");
        b.append("light[").append(this.baseLight).append("] ");
        b.append("translucent[").append(this.translucent).append("] ");
        b.append("multitexture[").append(this.multitexture).append("] ");
        b.append("layers[").append(this.layers).append("] ");
        return b.toString();
    }

    public static Vector3f unpackColor(int color) {
        long tmpColor = color;
        if ((tmpColor & 0xFFFFFFFFFC000000L) == 0L) {
            tmpColor |= 0xFFFFFFFFFF000000L;
        }
        float colorRed = (float)(tmpColor >> 16 & 0xFFL) / 255.0f;
        float colorGreen = (float)(tmpColor >> 8 & 0xFFL) / 255.0f;
        float colorBlue = (float)(tmpColor & 0xFFL) / 255.0f;
        return new Vector3f(colorRed, colorGreen, colorBlue);
    }

    public static class ClientUtils {
        public static void loadSettings(GolemRenderSettings settings) {
            settings.base = settings.multitexture.isPresent() ? new ResourcePair(new ResourceLocation("multitexture"), true) : ClientUtils.buildPreferredTexture(settings.baseList);
            settings.baseTemplate = new ResourceLocation(settings.baseTemplateRaw.m_135827_(), "textures/entity/golem/" + settings.baseTemplateRaw.m_135815_() + ".png");
            settings.multitexture.ifPresent(MultitextureRenderSettings.ClientUtils::loadMultitextureSettings);
            settings.layers.forEach(LayerRenderSettings.ClientUtil::loadLayerRenderSettings);
        }

        public static ResourcePair buildPreferredTexture(List<ResourcePair> textureList) {
            for (ResourcePair texture : textureList) {
                ResourceLocation loadedTexture = null;
                loadedTexture = texture.flag() ? new ResourceLocation(texture.resource().m_135827_(), "textures/entity/golem/" + texture.resource().m_135815_() + ".png") : new ResourceLocation(texture.resource().m_135827_(), "textures/block/" + texture.resource().m_135815_() + ".png");
                Optional r = Minecraft.m_91087_().m_91098_().m_213713_(loadedTexture);
                if (!r.isPresent()) continue;
                return new ResourcePair(loadedTexture, texture.flag());
            }
            return new ResourcePair(FALLBACK_PREFAB, true);
        }
    }
}

