/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.render;

import com.google.common.collect.ImmutableList;
import com.mcmoddev.golems.container.render.GolemRenderSettings;
import com.mcmoddev.golems.util.ResourcePair;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class LayerRenderSettings {
    public static final LayerRenderSettings EMPTY = new LayerRenderSettings(ResourcePair.EMPTY, Optional.empty());
    public static final LayerRenderSettings RAINBOW = new LayerRenderSettings(new ResourcePair(new ResourceLocation("golems", "layer/vines_rainbow"), true), Optional.empty());
    public static final LayerRenderSettings EYES = new LayerRenderSettings(new ResourcePair(new ResourceLocation("golems:layer/eyes/eyes"), true), Optional.empty());
    public static final LayerRenderSettings VINES = new LayerRenderSettings(new ResourcePair(new ResourceLocation("golems:layer/vines"), true), Optional.of(8626266));
    public static final Codec<LayerRenderSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourcePair.CODEC.optionalFieldOf("texture", (Object)ResourcePair.EMPTY).forGetter(LayerRenderSettings::getTextureRaw), (App)ResourceLocation.f_135803_.optionalFieldOf("template", (Object)GolemRenderSettings.BASE_TEMPLATE).forGetter(LayerRenderSettings::getTemplateRaw), (App)Codec.INT.optionalFieldOf("color").forGetter(LayerRenderSettings::getColor), (App)Codec.BOOL.optionalFieldOf("light").forGetter(LayerRenderSettings::getLight), (App)Codec.BOOL.optionalFieldOf("translucent", (Object)false).forGetter(LayerRenderSettings::isTranslucent)).apply((Applicative)instance, LayerRenderSettings::new));
    private final ResourcePair textureRaw;
    private ResourcePair texture;
    private final ResourceLocation templateRaw;
    private ResourceLocation template;
    private final Optional<Integer> color;
    private final Optional<Boolean> light;
    private final boolean translucent;
    private final boolean enabled;

    private LayerRenderSettings(ResourcePair textureRaw, Optional<Integer> color) {
        this(textureRaw, GolemRenderSettings.BASE_TEMPLATE, color, Optional.empty(), false);
    }

    private LayerRenderSettings(ResourcePair textureRaw, ResourceLocation templateRaw, Optional<Integer> color, Optional<Boolean> light, boolean translucent) {
        this.textureRaw = textureRaw;
        this.templateRaw = templateRaw;
        this.texture = GolemRenderSettings.NOT_LOADED;
        this.color = color;
        this.light = light;
        this.translucent = translucent;
        this.enabled = null != textureRaw && null != textureRaw.resource() && !ResourcePair.EMPTY.equals(textureRaw) && !textureRaw.resource().m_135815_().isEmpty();
    }

    public ResourcePair getTextureRaw() {
        return this.textureRaw;
    }

    public ResourcePair getTexture() {
        return this.texture;
    }

    public ResourceLocation getTemplateRaw() {
        return this.templateRaw;
    }

    public ResourceLocation getTemplate() {
        return this.template;
    }

    public Optional<Integer> getColor() {
        return this.color;
    }

    public Optional<Boolean> getLight() {
        return this.light;
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("LayerRenderSettings: ");
        b.append("texture[").append(this.texture).append("] ");
        b.append("color[").append(this.color).append("] ");
        b.append("light[").append(this.light).append("] ");
        b.append("translucent[").append(this.translucent).append("] ");
        return b.toString();
    }

    public static class ClientUtil {
        public static void loadLayerRenderSettings(LayerRenderSettings settings) {
            settings.texture = GolemRenderSettings.ClientUtils.buildPreferredTexture((List<ResourcePair>)ImmutableList.of((Object)settings.textureRaw));
            settings.template = new ResourceLocation(settings.templateRaw.m_135827_(), "textures/entity/golem/" + settings.templateRaw.m_135815_() + ".png");
        }
    }
}

