/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.ForgeHooks;

public interface IFuelConsumer {
    public static final String KEY_FUEL = "Fuel";

    public void setFuel(int var1);

    public int getFuel();

    public int getMaxFuel();

    default public void saveFuel(CompoundTag tag) {
        tag.m_128405_(KEY_FUEL, this.getFuel());
    }

    default public void loadFuel(CompoundTag tag) {
        this.setFuel(tag.m_128451_(KEY_FUEL));
    }

    default public boolean hasFuel() {
        return this.getFuel() > 0;
    }

    default public float getFuelPercentage() {
        return (float)this.getFuel() / (float)this.getMaxFuel();
    }

    default public void addFuel(int toAdd) {
        if (toAdd != 0) {
            this.setFuel(this.getFuel() + toAdd);
        }
    }

    default public void consumeFuel(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int burnTime = ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) * (player.m_6047_() ? stack.m_41613_() : 1);
        if (burnTime > 0 && this.getFuel() + burnTime <= this.getMaxFuel()) {
            if (player.m_6047_()) {
                this.addFuel(burnTime * stack.m_41613_());
                stack = stack.getCraftingRemainingItem();
            } else {
                this.addFuel(burnTime);
                if (stack.m_41613_() > 1) {
                    stack.m_41774_(1);
                } else {
                    stack = stack.getCraftingRemainingItem();
                }
            }
            player.m_21008_(hand, stack);
        }
        if (stack.m_41720_() == Items.f_42447_) {
            this.setFuel(0);
            player.m_21008_(hand, stack.getCraftingRemainingItem());
        }
    }
}

