/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.goal;

import com.mcmoddev.golems.container.behavior.parameter.BehaviorParameter;
import com.mcmoddev.golems.entity.GolemBase;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class PassiveEffectsGoal
extends Goal {
    protected final GolemBase golem;
    protected final MobEffectInstance[] effects;
    protected final boolean nightOnly;
    protected final BehaviorParameter.Target target;
    protected final float chance;
    protected final double range;

    public PassiveEffectsGoal(GolemBase golemIn, MobEffectInstance[] effectsIn, boolean nightOnlyIn, BehaviorParameter.Target targetIn, float chanceIn, double rangeIn) {
        this.golem = golemIn;
        this.effects = effectsIn;
        this.nightOnly = nightOnlyIn;
        this.target = targetIn;
        this.chance = chanceIn;
        this.range = rangeIn > 0.0 ? rangeIn : golemIn.m_21051_(Attributes.f_22277_).m_22115_() * 0.5;
    }

    public boolean m_8036_() {
        if (this.effects.length <= 0) {
            return false;
        }
        if (this.nightOnly && this.golem.f_19853_.m_46461_() && this.golem.f_19853_.m_6042_().f_223549_()) {
            return false;
        }
        if (this.target == BehaviorParameter.Target.ENEMY && null == this.golem.m_5448_()) {
            return false;
        }
        return this.golem.m_217043_().m_188501_() < this.chance;
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        MobEffectInstance effect = new MobEffectInstance(this.effects[this.golem.m_217043_().m_188503_(this.effects.length)]);
        switch (this.target) {
            case AREA: {
                double inflate = this.range > 0.0 ? this.range : 2.0;
                TargetingConditions condition = TargetingConditions.m_148353_().m_148355_().m_26893_();
                List targets = this.golem.f_19853_.m_45971_(LivingEntity.class, condition, (LivingEntity)this.golem, this.golem.m_20191_().m_82400_(inflate));
                for (LivingEntity target : targets) {
                    this.applyEffect(target, effect);
                }
                break;
            }
            case SELF: {
                this.applyEffect((LivingEntity)this.golem, effect);
                break;
            }
            case ENEMY: {
                this.applyEffect(this.golem.m_5448_(), effect);
            }
        }
    }

    private void applyEffect(LivingEntity target, MobEffectInstance effect) {
        if (effect != null && target != null && target.m_21220_().isEmpty()) {
            target.m_7292_(effect);
        }
    }
}

