/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.render;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.render.GolemRenderSettings;
import com.mcmoddev.golems.container.render.LayerRenderSettings;
import com.mcmoddev.golems.render.DynamicTextureState;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;

public class GolemRenderType
extends RenderType {
    private static final Set<ResourceLocation> loadedRenderSettings = new HashSet<ResourceLocation>();
    private static final Map<ResourceLocation, DynamicTextureState> dynamicTextureMap = new HashMap<ResourceLocation, DynamicTextureState>();

    public GolemRenderType(String name, VertexFormat vertexFormat, VertexFormat.Mode glQuads, int i2, boolean b1, boolean b2, Runnable r1, Runnable r2) {
        super(name, vertexFormat, glQuads, i2, b1, b2, r1, r2);
    }

    public static GolemRenderSettings loadRenderSettings(RegistryAccess access, ResourceLocation material) {
        Registry registry = access.m_175515_(ExtraGolems.Keys.GOLEM_MODELS);
        GolemRenderSettings settings = registry.m_6612_(material).orElse(GolemRenderSettings.EMPTY);
        if (!loadedRenderSettings.contains(material)) {
            loadedRenderSettings.add(material);
            GolemRenderSettings.ClientUtils.loadSettings(settings);
            LayerRenderSettings.ClientUtil.loadLayerRenderSettings(LayerRenderSettings.RAINBOW);
        }
        return settings;
    }

    public static void clearLoadedRenderSettings() {
        loadedRenderSettings.clear();
    }

    public static void reloadDynamicTextureMap() {
        GolemRenderType.clearLoadedRenderSettings();
        HashMap<ResourceLocation, DynamicTextureState> copy = new HashMap<ResourceLocation, DynamicTextureState>(dynamicTextureMap);
        copy.entrySet().forEach(e -> dynamicTextureMap.put((ResourceLocation)e.getKey(), new DynamicTextureState((ResourceLocation)e.getKey(), ((DynamicTextureState)e.getValue()).sourceImage, ((DynamicTextureState)e.getValue()).templateImage)));
    }

    private static RenderStateShard.TextureStateShard getTextureState(ResourceLocation texture, ResourceLocation template) {
        ResourceLocation id = new ResourceLocation(texture.m_135827_(), "dynamic/" + template.m_135815_() + "/" + texture.m_135815_());
        if (!dynamicTextureMap.containsKey(id)) {
            dynamicTextureMap.put(id, new DynamicTextureState(id, texture, template));
        }
        return GolemRenderType.dynamicTextureMap.get((Object)id).state;
    }

    public static RenderType getGolemCutout(ResourceLocation texture, ResourceLocation template, boolean dynamic) {
        if (!dynamic) {
            return RenderType.m_110458_((ResourceLocation)texture);
        }
        return GolemRenderType.m_173215_((String)"golem_cutout", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173113_).m_110685_(f_110134_).m_110671_(f_110152_).m_110677_(f_110154_).m_110661_(f_110110_).m_173290_((RenderStateShard.EmptyTextureStateShard)GolemRenderType.getTextureState(texture, template)).m_110691_(true));
    }

    public static RenderType getGolemTranslucent(ResourceLocation texture, ResourceLocation template, boolean dynamic) {
        if (!dynamic) {
            return RenderType.m_110473_((ResourceLocation)texture);
        }
        return GolemRenderType.m_173215_((String)"golem_transparent", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173066_).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_173290_((RenderStateShard.EmptyTextureStateShard)GolemRenderType.getTextureState(texture, template)).m_110691_(true));
    }

    public static RenderType getGolemOutline(ResourceLocation texture, ResourceLocation template, boolean dynamic) {
        if (!dynamic) {
            return RenderType.m_110491_((ResourceLocation)texture);
        }
        return GolemRenderType.m_173215_((String)"golem_outline", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173077_).m_110661_(RenderStateShard.CullStateShard.f_110110_).m_110663_(f_110111_).m_110675_(f_110124_).m_173290_((RenderStateShard.EmptyTextureStateShard)GolemRenderType.getTextureState(texture, template)).m_110689_(RenderType.OutlineProperty.IS_OUTLINE));
    }
}

