/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems;

import com.mcmoddev.golems.EGRegistry;
import com.mcmoddev.golems.render.GolemModel;
import com.mcmoddev.golems.render.GolemRenderType;
import com.mcmoddev.golems.render.GolemRenderer;
import com.mcmoddev.golems.screen.DispenserGolemScreen;
import com.mcmoddev.golems.screen.guide_book.GolemBookScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class EGClientEvents {
    public static void register() {
        MinecraftForge.EVENT_BUS.register(ForgeHandler.class);
        FMLJavaModLoadingContext.get().getModEventBus().register(ModHandler.class);
        ModHandler.addResources();
    }

    public static final class ForgeHandler {
        @SubscribeEvent
        public static void onDatapackSync(OnDatapackSyncEvent event) {
            ForgeHandler.onClearGolemModels();
        }

        public static void onClearGolemModels() {
            GolemRenderType.clearLoadedRenderSettings();
        }

        public static void loadBookGui(Player playerIn, ItemStack itemstack) {
            if (!playerIn.m_20193_().m_5776_()) {
                return;
            }
            Minecraft.m_91087_().m_91152_((Screen)new GolemBookScreen(playerIn, itemstack));
        }
    }

    public static class ModHandler {
        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent event) {
            event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)EGRegistry.DISPENSER_GOLEM_MENU.get()), DispenserGolemScreen::new));
        }

        @SubscribeEvent
        public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(GolemRenderer.GOLEM_MODEL_RESOURCE, GolemModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)EGRegistry.GOLEM.get(), GolemRenderer::new);
        }

        public static void addResources() {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            if (resourceManager instanceof ReloadableResourceManager) {
                ((ReloadableResourceManager)resourceManager).m_7217_((PreparableReloadListener)new SimplePreparableReloadListener<ModelBakery>(){

                    protected ModelBakery prepare(ResourceManager arg0, ProfilerFiller arg1) {
                        return null;
                    }

                    protected void apply(ModelBakery arg0, ResourceManager arg1, ProfilerFiller arg2) {
                        GolemRenderType.reloadDynamicTextureMap();
                    }

                    public String m_7812_() {
                        return "Extra Golems textures";
                    }
                });
            }
        }
    }
}

