/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.GolemContainer;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.ForgeConfigSpec;

public final class EGConfig {
    private static final TagKey<GolemContainer> VILLAGER_SUMMONABLE = TagKey.m_203882_(ExtraGolems.Keys.GOLEM_CONTAINERS, (ResourceLocation)new ResourceLocation("golems", "villager_summonable"));
    private final ForgeConfigSpec.BooleanValue BEDROCK_GOLEM_CREATIVE_ONLY;
    private final ForgeConfigSpec.BooleanValue PUMPKIN_BUILDS_GOLEMS;
    private final ForgeConfigSpec.BooleanValue ENABLE_FRIENDLY_FIRE;
    private final ForgeConfigSpec.BooleanValue ENABLE_USE_SPELL_ITEM;
    private final ForgeConfigSpec.BooleanValue ENABLE_HEAL_GOLEMS;
    private final ForgeConfigSpec.BooleanValue ENABLE_HOLIDAYS;
    private final ForgeConfigSpec.IntValue VILLAGER_GOLEM_SPAWN_CHANCE;
    private boolean aprilFirst;
    private boolean halloween;
    private boolean pride;
    private boolean bedrockGolemCreativeOnly;
    private boolean pumpkinBuildsGolems;
    private boolean enableFriendlyFire;
    private boolean enableUseSpellItem;
    private boolean enableHealGolems;
    private boolean enableHolidays;
    private int villagerGolemSpawnChance;
    private List<ResourceLocation> villagerGolemSpawnList;

    public EGConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.BEDROCK_GOLEM_CREATIVE_ONLY = builder.comment("When true, only players in creative mode can use a Bedrock Golem spawn item").define("bedrock_golem_creative_only", true);
        this.PUMPKIN_BUILDS_GOLEMS = builder.comment("When true, pumpkins can be used to build this mod's golems").define("pumpkin_builds_golems", false);
        this.ENABLE_FRIENDLY_FIRE = builder.comment("When enabled, attacking a player-built entity will make it attack you").define("friendly_fire", true);
        this.ENABLE_USE_SPELL_ITEM = builder.comment("When enabled, players can use the spell item on a carved pumpkin to convert it to a golem head in-world").define("use_spell", true);
        this.ENABLE_HOLIDAYS = builder.comment("Super secret special days").define("holidays", true);
        this.VILLAGER_GOLEM_SPAWN_CHANCE = builder.comment("Percent chance for a villager to summon an Extra Golems entity").defineInRange("villager_summon_chance", 60, 0, 100);
        this.ENABLE_HEAL_GOLEMS = builder.comment("When enabled, giving blocks and items to golems can restore health").define("heal_golems", true);
        builder.pop();
    }

    public boolean isBedrockGolemCreativeOnly() {
        return this.bedrockGolemCreativeOnly;
    }

    public boolean pumpkinBuildsGolems() {
        return this.pumpkinBuildsGolems;
    }

    public boolean enableFriendlyFire() {
        return this.enableFriendlyFire;
    }

    public boolean enableUseSpellItem() {
        return this.enableUseSpellItem;
    }

    public boolean enableHealGolems() {
        return this.enableHealGolems;
    }

    public int villagerSummonChance() {
        return this.villagerGolemSpawnChance;
    }

    public boolean aprilFirst() {
        return this.enableHolidays && this.aprilFirst;
    }

    public boolean halloween() {
        return this.enableHolidays && this.halloween;
    }

    public boolean pride() {
        return this.enableHolidays && this.pride;
    }

    public void bake() {
        LocalDateTime now = LocalDateTime.now();
        this.aprilFirst = now.getMonth() == Month.MARCH && now.getDayOfMonth() >= 31 || now.getMonth() == Month.APRIL && now.getDayOfMonth() <= 2;
        this.halloween = now.getMonth() == Month.OCTOBER && now.getDayOfMonth() >= 30 || now.getMonth() == Month.NOVEMBER && now.getDayOfMonth() <= 2;
        this.pride = now.getMonth() == Month.JUNE && now.getDayOfMonth() <= 3;
        this.bedrockGolemCreativeOnly = (Boolean)this.BEDROCK_GOLEM_CREATIVE_ONLY.get();
        this.pumpkinBuildsGolems = (Boolean)this.PUMPKIN_BUILDS_GOLEMS.get();
        this.enableFriendlyFire = (Boolean)this.ENABLE_FRIENDLY_FIRE.get();
        this.enableUseSpellItem = (Boolean)this.ENABLE_USE_SPELL_ITEM.get();
        this.enableHolidays = (Boolean)this.ENABLE_HOLIDAYS.get();
        this.enableHealGolems = (Boolean)this.ENABLE_HEAL_GOLEMS.get();
        this.villagerGolemSpawnChance = (Integer)this.VILLAGER_GOLEM_SPAWN_CHANCE.get();
    }
}

