/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.block.GlowBlock;
import com.mcmoddev.golems.block.GolemHeadBlock;
import com.mcmoddev.golems.block.PowerBlock;
import com.mcmoddev.golems.container.GolemContainer;
import com.mcmoddev.golems.container.render.GolemRenderSettings;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.item.GolemHeadItem;
import com.mcmoddev.golems.item.GolemSpellItem;
import com.mcmoddev.golems.item.GuideBookItem;
import com.mcmoddev.golems.item.SpawnGolemItem;
import com.mcmoddev.golems.menu.PortableDispenserMenu;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class EGRegistry {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"golems");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"golems");
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"golems");
    private static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"golems");
    public static final DeferredRegister<GolemContainer> GOLEM_CONTAINERS = DeferredRegister.create(ExtraGolems.Keys.GOLEM_CONTAINERS, (String)"golems");
    public static final DeferredRegister<GolemRenderSettings> GOLEM_MODELS = DeferredRegister.create(ExtraGolems.Keys.GOLEM_MODELS, (String)"golems");
    public static final RegistryObject<Block> GOLEM_HEAD = BLOCKS.register("golem_head", () -> new GolemHeadBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50143_)));
    public static final RegistryObject<GlowBlock> UTILITY_LIGHT = BLOCKS.register("light_provider", () -> new GlowBlock(Material.f_76275_, 1.0f));
    public static final RegistryObject<PowerBlock> UTILITY_POWER = BLOCKS.register("power_provider", () -> new PowerBlock(15));
    public static final RegistryObject<Item> GOLEM_HEAD_ITEM = ITEMS.register("golem_head", () -> new GolemHeadItem((Block)GOLEM_HEAD.get(), new Item.Properties()));
    public static final RegistryObject<GolemSpellItem> GOLEM_SPELL = ITEMS.register("golem_spell", () -> new GolemSpellItem(new Item.Properties()));
    public static final RegistryObject<SpawnGolemItem> SPAWN_BEDROCK_GOLEM = ITEMS.register("spawn_bedrock_golem", () -> new SpawnGolemItem(new Item.Properties()));
    public static final RegistryObject<GuideBookItem> INFO_BOOK = ITEMS.register("info_book", () -> new GuideBookItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<? extends EntityType<GolemBase>> GOLEM = ENTITY_TYPES.register("golem", () -> EntityType.Builder.m_20704_(GolemBase::new, (MobCategory)MobCategory.MISC).setTrackingRange(48).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).m_20699_(1.4f, 2.7f).m_20698_().m_20712_("golem"));
    public static final RegistryObject<MenuType<PortableDispenserMenu>> DISPENSER_GOLEM_MENU = MENU_TYPES.register("dispenser_portable", () -> new MenuType(PortableDispenserMenu::new));

    private EGRegistry() {
    }

    public static void init() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        ENTITY_TYPES.register(eventBus);
        MENU_TYPES.register(eventBus);
        GOLEM_CONTAINERS.register(eventBus);
        GOLEM_MODELS.register(eventBus);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EGRegistry::registerEntityAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EGRegistry::onBuildTabContents);
    }

    public static void onBuildTabContents(CreativeModeTabEvent.BuildContents event) {
        if (event.getTab() == CreativeModeTabs.f_256869_) {
            event.accept(GOLEM_SPELL);
            event.accept(INFO_BOOK);
            event.accept(GOLEM_HEAD_ITEM);
        }
        if (event.getTab() == CreativeModeTabs.f_256791_) {
            event.accept(GOLEM_HEAD_ITEM);
        }
        if (event.getTab() == CreativeModeTabs.f_256776_) {
            event.getEntries().putAfter((Object)Items.f_42055_.m_7968_(), (Object)((Item)GOLEM_HEAD_ITEM.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)GOLEM.get(), GolemContainer.EMPTY.getAttributeSupplier().get().m_22265_());
    }
}

