/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class AttributeSettings {
    private static final double MAX_HEALTH = 1024.0;
    public static final AttributeSettings EMPTY = new AttributeSettings(1024.0, 0.0, 0.0, 0.0, 0.0, 0.0, false, false, false, false, false);
    public static final Codec<AttributeSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("health", (Object)100.0).forGetter(AttributeSettings::getHealth), (App)Codec.DOUBLE.optionalFieldOf("attack", (Object)10.0).forGetter(AttributeSettings::getAttack), (App)Codec.DOUBLE.optionalFieldOf("speed", (Object)0.25).forGetter(AttributeSettings::getSpeed), (App)Codec.DOUBLE.optionalFieldOf("knockback_resistance", (Object)0.4).forGetter(AttributeSettings::getKnockbackResist), (App)Codec.DOUBLE.optionalFieldOf("armor", (Object)0.0).forGetter(AttributeSettings::getArmor), (App)Codec.DOUBLE.optionalFieldOf("attack_knockback", (Object)0.0).forGetter(AttributeSettings::getAttackKnockback), (App)Codec.BOOL.optionalFieldOf("immune_to_fire", (Object)false).forGetter(AttributeSettings::hasFireImmunity), (App)Codec.BOOL.optionalFieldOf("immune_to_explosions", (Object)false).forGetter(AttributeSettings::hasExplosionImmunity), (App)Codec.BOOL.optionalFieldOf("hurt_by_water", (Object)false).forGetter(AttributeSettings::isHurtByWater), (App)Codec.BOOL.optionalFieldOf("hurt_by_fall", (Object)false).forGetter(AttributeSettings::isHurtByFall), (App)Codec.BOOL.optionalFieldOf("hurt_by_heat", (Object)false).forGetter(AttributeSettings::isHurtByHeat)).apply((Applicative)instance, AttributeSettings::new));
    private final double health;
    private final double attack;
    private final double speed;
    private final double knockbackResist;
    private final double armor;
    private final double attackKnockback;
    private final boolean fireImmunity;
    private final boolean explosionImmunity;
    private final boolean hurtByWater;
    private final boolean hurtByFall;
    private final boolean hurtByHeat;

    private AttributeSettings(double health, double attack, double speed, double knockbackResist, double armor, double attackKnockback, boolean fireImmunity, boolean explosionImmunity, boolean hurtByWater, boolean hurtByFall, boolean hurtByHeat) {
        this.health = Math.min(health, 1024.0);
        this.attack = attack;
        this.speed = speed;
        this.knockbackResist = knockbackResist;
        this.armor = armor;
        this.attackKnockback = attackKnockback;
        this.fireImmunity = fireImmunity;
        this.explosionImmunity = explosionImmunity;
        this.hurtByWater = hurtByWater;
        this.hurtByFall = hurtByFall;
        this.hurtByHeat = hurtByHeat;
    }

    public double getHealth() {
        return this.health;
    }

    public double getAttack() {
        return this.attack;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getKnockbackResist() {
        return this.knockbackResist;
    }

    public double getArmor() {
        return this.armor;
    }

    public double getAttackKnockback() {
        return this.attackKnockback;
    }

    public boolean hasFireImmunity() {
        return this.fireImmunity;
    }

    public boolean hasExplosionImmunity() {
        return this.explosionImmunity;
    }

    public boolean isHurtByWater() {
        return this.hurtByWater;
    }

    public boolean isHurtByFall() {
        return this.hurtByFall;
    }

    public boolean isHurtByHeat() {
        return this.hurtByHeat;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("AttributeSettings: ");
        b.append("health[").append(this.health).append("] ");
        b.append("attack[").append(this.attack).append("] ");
        b.append("speed[").append(this.speed).append("] ");
        b.append("resist[").append(this.knockbackResist).append("] ");
        b.append("armor[").append(this.armor).append("] ");
        b.append("knockback[").append(this.attackKnockback).append("] ");
        b.append("fire_immune[").append(this.fireImmunity).append("] ");
        b.append("explode_immune[").append(this.explosionImmunity).append("] ");
        b.append("hurt_by_water[").append(this.hurtByWater).append("] ");
        b.append("hurt_by_fall[").append(this.hurtByFall).append("] ");
        b.append("hurt_by_heat[").append(this.hurtByHeat).append("] ");
        return b.toString();
    }
}

