/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior;

import com.google.common.collect.ImmutableMap;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.behavior.parameter.BehaviorParameter;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.util.ResourcePair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

@Immutable
public abstract class GolemBehavior {
    protected static final MutableComponent FIRE_DESC = Component.m_237115_((String)"entitytip.lights_mobs_on_fire").m_130940_(ChatFormatting.GOLD);
    protected static final MutableComponent EFFECTS_SELF_DESC = Component.m_237115_((String)"entitytip.potion_effects_self").m_130940_(ChatFormatting.LIGHT_PURPLE);
    protected static final MutableComponent EFFECTS_ENEMY_DESC = Component.m_237115_((String)"entitytip.potion_effects_enemy").m_130940_(ChatFormatting.LIGHT_PURPLE);
    protected final CompoundTag tag;

    public GolemBehavior(CompoundTag tag) {
        this.tag = tag;
    }

    public void onRegisterGoals(GolemBase entity) {
    }

    public void onTick(GolemBase entity) {
    }

    public void onHurtTarget(GolemBase entity, Entity target) {
    }

    public void onActuallyHurt(GolemBase entity, DamageSource source, float amount) {
    }

    public void onMobInteract(GolemBase entity, Player player, InteractionHand hand) {
    }

    public void onDie(GolemBase entity, DamageSource source) {
    }

    public void onWriteData(GolemBase entity, CompoundTag tag) {
    }

    public void onReadData(GolemBase entity, CompoundTag tag) {
    }

    public void onAddDescriptions(List<Component> list) {
    }

    public static void sendParticles(Entity entity, ParticleOptions particle, int count) {
        Vec3 pos = entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() * 0.5, 0.0);
        if (entity.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)entity.f_19853_).m_8767_(particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, count, 0.5, 0.5, 0.5, 0.0);
        }
    }

    protected static <T extends BehaviorParameter> Map<ResourcePair, T> readParameters(CompoundTag items, Function<CompoundTag, T> constructor) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (String resource : items.m_128431_()) {
            Optional pair = ResourcePair.read(resource).resultOrPartial(s -> ExtraGolems.LOGGER.error("Failed to parse item ID or tag from " + s));
            if (!pair.isPresent()) continue;
            CompoundTag paramTag = items.m_128469_(resource);
            BehaviorParameter param = (BehaviorParameter)constructor.apply(paramTag);
            builder.put((Object)((ResourcePair)pair.get()), (Object)param);
        }
        return builder.build();
    }
}

