/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mcmoddev.golems.container.render.GolemRenderSettings;
import com.mcmoddev.golems.util.ResourcePair;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;

public class MultitextureRenderSettings {
    public static final MultitextureRenderSettings EMPTY = new MultitextureRenderSettings(Maps.newHashMap());
    public static final Codec<MultitextureRenderSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING.xmap(Integer::parseInt, i -> Integer.toString(i)), ResourcePair.CODEC).fieldOf("base_map").forGetter(MultitextureRenderSettings::getBaseMapRaw)).apply((Applicative)instance, MultitextureRenderSettings::new));
    private final ImmutableMap<Integer, ResourcePair> baseMapRaw;
    private ImmutableMap<Integer, ResourcePair> baseMap;

    private MultitextureRenderSettings(Map<Integer, ResourcePair> baseMapRaw) {
        this.baseMapRaw = ImmutableMap.copyOf(baseMapRaw);
        this.baseMap = ImmutableMap.of();
    }

    public Map<Integer, ResourcePair> getBaseMapRaw() {
        return this.baseMapRaw;
    }

    public Map<Integer, ResourcePair> getBaseMap() {
        return this.baseMap;
    }

    public String toString() {
        return "MultitextureRenderSettings: ".concat("base_map[").concat(this.baseMapRaw.toString()).concat("] ");
    }

    public static class ClientUtils {
        public static void loadMultitextureSettings(MultitextureRenderSettings settings) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            settings.baseMapRaw.forEach((num, pair) -> builder.put(num, (Object)GolemRenderSettings.ClientUtils.buildPreferredTexture((List<ResourcePair>)ImmutableList.of((Object)pair))));
            settings.baseMap = builder.build();
        }
    }
}

