/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.goal;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class FollowGoal
extends Goal {
    protected final Mob entity;
    protected final Predicate<LivingEntity> followPredicate;
    protected LivingEntity followingEntity;
    protected final double speedModifier;
    protected final PathNavigation navigation;
    protected int timeToRecalcPath;
    protected final float stopDistance;
    protected float oldWaterCost;
    protected final float areaSize;

    public FollowGoal(Mob entityIn, double speed, float stopDistanceIn, float areaSizeIn, Predicate<LivingEntity> followPredicateIn) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = entityIn;
        this.followPredicate = followPredicateIn;
        this.speedModifier = speed;
        this.navigation = entityIn.m_21573_();
        this.stopDistance = stopDistanceIn;
        this.areaSize = areaSizeIn;
        if (!(entityIn.m_21573_() instanceof GroundPathNavigation) && !(entityIn.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowGoal");
        }
    }

    public boolean m_8036_() {
        List mobEntityList = this.entity.f_19853_.m_6443_(LivingEntity.class, this.entity.m_20191_().m_82400_((double)this.areaSize), this.followPredicate);
        if (!mobEntityList.isEmpty()) {
            for (LivingEntity mobEntity : mobEntityList) {
                if (mobEntity.m_20145_()) continue;
                this.followingEntity = mobEntity;
                return true;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        return this.followingEntity != null && !this.navigation.m_26571_() && this.entity.m_20280_((Entity)this.followingEntity) > (double)(this.stopDistance * this.stopDistance);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.m_21439_(BlockPathTypes.WATER);
        this.entity.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.followingEntity = null;
        this.navigation.m_26573_();
        this.entity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        double dZ;
        double dY;
        if (this.followingEntity == null || this.entity.m_21523_()) {
            return;
        }
        this.entity.m_21563_().m_24960_((Entity)this.followingEntity, 10.0f, (float)this.entity.m_8132_());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = 10;
        double dX = this.entity.m_20185_() - this.followingEntity.m_20185_();
        double distanceSq = dX * dX + (dY = this.entity.m_20186_() - this.followingEntity.m_20186_()) * dY + (dZ = this.entity.m_20189_() - this.followingEntity.m_20189_()) * dZ;
        if (distanceSq <= (double)(this.stopDistance * this.stopDistance)) {
            this.navigation.m_26573_();
            return;
        }
        this.navigation.m_5624_((Entity)this.followingEntity, this.speedModifier);
    }
}

