/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.goal;

import com.mcmoddev.golems.entity.GolemBase;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PlaceUtilityBlocksGoal
extends Goal {
    public final GolemBase golem;
    public final BlockState stateToPlace;
    public final int tickDelay;
    public final BiPredicate<GolemBase, BlockPos> predicate;
    public static final BiPredicate<GolemBase, BlockPos> ABOVE_AIR_PRED = (g, pos) -> g.f_19853_.m_46859_(pos.m_7495_());
    public static final BiPredicate<GolemBase, BlockPos> ABOVE_WATER_PRED = (g, pos) -> g.f_19853_.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_49990_;

    public PlaceUtilityBlocksGoal(GolemBase golemIn, BlockState stateIn, int interval, boolean onlyAboveEmpty, @Nullable BiPredicate<GolemBase, BlockPos> otherPredicate) {
        this.golem = golemIn;
        this.stateToPlace = stateIn;
        this.tickDelay = interval;
        BiPredicate<GolemBase, BlockPos> pred = PlaceUtilityBlocksGoal.makeBiPred(stateIn, onlyAboveEmpty);
        this.predicate = otherPredicate != null ? pred.and(otherPredicate) : pred;
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8036_() {
        return true;
    }

    public void m_8037_() {
        if (this.golem.f_19797_ % this.tickDelay == 0) {
            BlockPos blockPosIn = this.golem.getBlockBelow().m_7494_();
            for (int i = 0; i < 4; ++i) {
                BlockPos pos = blockPosIn.m_6630_(i);
                BlockState cur = this.golem.f_19853_.m_8055_(pos);
                if (cur.m_60734_() == this.stateToPlace.m_60734_()) {
                    return;
                }
                if (!this.predicate.test(this.golem, pos)) continue;
                this.golem.f_19853_.m_7731_(pos, this.getStateToPlace(cur), 6);
                return;
            }
        }
    }

    public void m_8056_() {
        this.m_8037_();
    }

    public static boolean canBeWaterlogged(BlockState stateIn) {
        return stateIn.m_61138_((Property)BlockStateProperties.f_61362_);
    }

    public static BlockState getStateWaterlogged(BlockState stateIn) {
        if (PlaceUtilityBlocksGoal.canBeWaterlogged(stateIn)) {
            return (BlockState)stateIn.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
        }
        return stateIn;
    }

    public static BiPredicate<GolemBase, BlockPos> makeBiPred(BlockState stateIn, boolean onlyAboveEmpty) {
        boolean canBeWaterlogged = PlaceUtilityBlocksGoal.canBeWaterlogged(stateIn);
        BiPredicate<GolemBase, BlockPos> pred = (golem, pos) -> golem.f_19853_.m_46859_(pos);
        if (canBeWaterlogged) {
            pred = pred.or((golem, pos) -> {
                BlockState toReplace = golem.f_19853_.m_8055_(pos);
                return toReplace.m_60734_() == Blocks.f_49990_ && (Integer)toReplace.m_61143_((Property)LiquidBlock.f_54688_) == 0;
            });
        }
        if (onlyAboveEmpty) {
            pred = canBeWaterlogged ? pred.and(ABOVE_WATER_PRED.or(ABOVE_AIR_PRED)) : pred.and(ABOVE_AIR_PRED);
        }
        return pred;
    }

    protected BlockState getStateToPlace(BlockState toReplace) {
        return toReplace.m_60734_() == Blocks.f_49990_ ? PlaceUtilityBlocksGoal.getStateWaterlogged(this.stateToPlace) : this.stateToPlace;
    }
}

