/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.item;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.GolemContainer;
import com.mcmoddev.golems.entity.GolemBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public final class SpawnGolemItem
extends Item {
    public static final ResourceLocation BEDROCK_GOLEM = new ResourceLocation("golems", "bedrock");

    public SpawnGolemItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level worldIn = context.m_43725_();
        Player player = context.m_43723_();
        Direction facing = context.m_43719_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        if (ExtraGolems.CONFIG.isBedrockGolemCreativeOnly() && !player.m_7500_() || facing == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        GolemContainer container = (GolemContainer)worldIn.m_8891_().m_175515_(ExtraGolems.Keys.GOLEM_CONTAINERS).m_7745_(BEDROCK_GOLEM);
        if (container != null) {
            BlockState state = worldIn.m_8055_(pos);
            BlockPos spawnPos = state.m_60816_((BlockGetter)context.m_43725_(), context.m_8083_()).m_83281_() ? pos : pos.m_121945_(context.m_43719_());
            if (!worldIn.m_5776_()) {
                GolemBase entity = GolemBase.create(worldIn, BEDROCK_GOLEM);
                entity.m_6027_(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_());
                worldIn.m_7967_((Entity)entity);
                entity.m_6518_((ServerLevelAccessor)((ServerLevel)worldIn), worldIn.m_6436_(spawnPos), MobSpawnType.SPAWN_EGG, null, null);
                entity.m_20331_(true);
            }
            if (!context.m_43723_().m_7500_()) {
                stack.m_41774_(1);
            }
            SpawnGolemItem.spawnParticles(worldIn, spawnPos.m_123341_(), (double)spawnPos.m_123342_() + 0.5, spawnPos.m_123343_(), 0.12);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity entity, InteractionHand hand) {
        GolemBase golem;
        if (entity instanceof GolemBase && (golem = (GolemBase)entity).getMaterial().equals((Object)BEDROCK_GOLEM)) {
            if (!entity.f_19853_.m_5776_()) {
                golem.m_146870_();
            }
            SpawnGolemItem.spawnParticles(playerIn.f_19853_, entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), 0.12);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void spawnParticles(Level world, double x, double y, double z, double motion) {
        SpawnGolemItem.spawnParticles(world, x, y, z, motion, (ParticleOptions)ParticleTypes.f_123755_, 60);
    }

    public static void spawnParticles(Level world, double x, double y, double z, double motion, ParticleOptions type, int num) {
        if (world.f_46443_) {
            for (int i = num + world.f_46441_.m_188503_(Math.max(1, num / 2)); i > 0; --i) {
                world.m_7106_(type, x + world.f_46441_.m_188500_() - 0.5, y + world.f_46441_.m_188500_() - 0.5, z + world.f_46441_.m_188500_() - 0.5, world.f_46441_.m_188500_() * motion - motion * 0.5, world.f_46441_.m_188500_() * motion * 0.5, world.f_46441_.m_188500_() * motion - motion * 0.5);
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        MutableComponent loreCreativeOnly = Component.m_237115_((String)"tooltip.creative_only_item").m_130940_(ChatFormatting.RED);
        MutableComponent lorePressShift = Component.m_237115_((String)"tooltip.press").m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.shift").m_130940_(ChatFormatting.YELLOW)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.for_more_details").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)loreCreativeOnly);
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.use_to_spawn", (Object[])new Object[]{Component.m_237115_((String)"entity.golems.golem.bedrock")}));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.use_on_existing", (Object[])new Object[]{Component.m_237115_((String)"entity.golems.golem.bedrock")}));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.to_remove_it"));
        } else {
            tooltip.add((Component)lorePressShift);
        }
    }
}

