/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.render;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.render.GolemRenderSettings;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.render.GolemModel;
import com.mcmoddev.golems.render.GolemRenderType;
import com.mcmoddev.golems.render.layer.ColoredTextureLayer;
import com.mcmoddev.golems.render.layer.GolemBannerLayer;
import com.mcmoddev.golems.render.layer.GolemCrackinessLayer;
import com.mcmoddev.golems.render.layer.GolemFlowerLayer;
import com.mcmoddev.golems.render.layer.GolemKittyLayer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public class GolemRenderer<T extends GolemBase>
extends MobRenderer<T, GolemModel<T>> {
    public static final ModelLayerLocation GOLEM_MODEL_RESOURCE = new ModelLayerLocation(new ResourceLocation("golems", "golem"), "main");
    protected static final ResourceLocation boneTexture = new ResourceLocation("golems", "textures/entity/golem/bone_skeleton.png");
    protected static final ResourceLocation specialTexture = new ResourceLocation("golems", "textures/entity/golem/special.png");
    protected static final ResourceLocation specialTexture2 = new ResourceLocation("golems", "textures/entity/golem/special2.png");
    protected static final ResourceLocation specialTexture3 = new ResourceLocation("golems", "textures/entity/golem/special3.png");
    protected boolean isAlphaLayer;

    public GolemRenderer(EntityRendererProvider.Context context) {
        super(context, new GolemModel(context.m_174023_(GOLEM_MODEL_RESOURCE)), 0.5f);
        this.m_115326_(new ColoredTextureLayer(this, context.m_174027_()));
        this.m_115326_(new GolemCrackinessLayer(this));
        this.m_115326_(new GolemFlowerLayer(this));
        this.m_115326_(new GolemKittyLayer(this));
        this.m_115326_(new GolemBannerLayer(this));
    }

    public void render(T golem, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (golem.m_20145_()) {
            return;
        }
        GolemRenderSettings settings = GolemRenderType.loadRenderSettings(((GolemBase)golem).f_19853_.m_8891_(), ((GolemBase)golem).getMaterial());
        matrixStackIn.m_85836_();
        if (((GolemBase)golem).m_6162_()) {
            float scaleChild = 0.5f;
            matrixStackIn.m_85841_(scaleChild, scaleChild, scaleChild);
        }
        ((GolemModel)this.m_7200_()).setSettings(settings, (GolemBase)golem);
        this.isAlphaLayer = settings.isTranslucent();
        if (this.isAlphaLayer) {
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        int packedLight = settings.getBaseLight().orElse(settings.getBaseLight().orElse(false)) != false ? 0xF000F0 : packedLightIn;
        super.m_7392_(golem, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLight);
        if (this.isAlphaLayer) {
            RenderSystem.m_69461_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrixStackIn.m_85849_();
    }

    public ResourceLocation getTextureLocation(T golem) {
        GolemRenderSettings settings = ((GolemModel)this.m_7200_()).getSettings();
        ResourceLocation texture = settings.getBase((GolemBase)golem).resource();
        boolean disableLayers = false;
        if (ExtraGolems.CONFIG.halloween() && GolemRenderer.isNightTime(golem)) {
            texture = boneTexture;
            disableLayers = true;
        } else if (golem.m_8077_()) {
            String name = ChatFormatting.m_126649_((String)golem.m_7755_().getString());
            if ("ganon".equalsIgnoreCase(name) || "ganondorf".equalsIgnoreCase(name)) {
                texture = specialTexture;
                disableLayers = true;
            } else if ("cookie".equalsIgnoreCase(name)) {
                texture = specialTexture2;
                disableLayers = true;
            } else if ("yeti".equalsIgnoreCase(name)) {
                texture = specialTexture3;
                disableLayers = true;
            }
        }
        ((GolemModel)this.m_7200_()).disableLayers(disableLayers);
        return texture;
    }

    @Nullable
    protected RenderType getRenderType(T golem, boolean isVisible, boolean isVisibleToPlayer, boolean isGlowing) {
        GolemRenderSettings settings = ((GolemModel)this.m_7200_()).getSettings();
        ResourceLocation texture = this.getTextureLocation(golem);
        ResourceLocation template = settings.getBaseTemplate();
        boolean dynamic = GolemRenderer.isDynamic(golem, texture, settings);
        if (isVisible || isVisibleToPlayer || this.isAlphaLayer) {
            return GolemRenderType.getGolemTranslucent(texture, template, dynamic);
        }
        if (isGlowing) {
            return GolemRenderType.getGolemOutline(texture, template, dynamic);
        }
        return GolemRenderType.getGolemCutout(texture, template, dynamic);
    }

    protected static boolean isSpecial(ResourceLocation texture) {
        return texture == boneTexture || texture == specialTexture || texture == specialTexture2 || texture == specialTexture3;
    }

    protected static <T extends GolemBase> boolean isDynamic(T entity, ResourceLocation texture, GolemRenderSettings settings) {
        return !GolemRenderer.isSpecial(texture) && !settings.getBase(entity).flag();
    }

    public static boolean isNightTime(GolemBase golem) {
        long time = golem.f_19853_.m_46468_() % 24000L;
        return time > 13000L && time < 23000L;
    }
}

