/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.render.layer;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.render.GolemRenderSettings;
import com.mcmoddev.golems.container.render.LayerRenderSettings;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.render.GolemModel;
import com.mcmoddev.golems.render.GolemRenderType;
import com.mcmoddev.golems.render.GolemRenderer;
import com.mcmoddev.golems.util.ResourcePair;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.animal.IronGolem;
import org.joml.Vector3f;

public class ColoredTextureLayer<T extends GolemBase>
extends RenderLayer<T, GolemModel<T>> {
    private static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    private final GolemModel<T> layerModel;

    public ColoredTextureLayer(RenderLayerParent<T, GolemModel<T>> renderParent, EntityModelSet modelSet) {
        super(renderParent);
        this.layerModel = new GolemModel(modelSet.m_171103_(GolemRenderer.GOLEM_MODEL_RESOURCE));
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        GolemRenderSettings settings = ((GolemModel)this.m_117386_()).getSettings();
        if (!(entity.m_20145_() || ((GolemModel)this.m_117386_()).disableLayers() || settings.getLayers().isEmpty())) {
            ((GolemModel)this.m_117386_()).m_102624_((EntityModel)this.layerModel);
            this.layerModel.m_6839_((IronGolem)entity, limbSwing, limbSwingAmount, partialTicks);
            this.layerModel.setupAnim(entity, limbSwing, limbSwingAmount, partialTicks, netHeadYaw, headPitch);
            int packedOverlay = LivingEntityRenderer.m_115338_(entity, (float)0.0f);
            settings.getLayers().forEach(l -> ColoredTextureLayer.renderTexture(entity, this.layerModel, settings, l, matrixStackIn, bufferIn, packedLightIn, packedOverlay));
            if (ExtraGolems.CONFIG.pride() || ChatFormatting.m_126649_((String)entity.m_7755_().getString()).toLowerCase(Locale.ENGLISH).contains("lgb")) {
                ColoredTextureLayer.renderTexture(entity, this.layerModel, settings, LayerRenderSettings.RAINBOW, matrixStackIn, bufferIn, packedLightIn, packedOverlay);
            }
        }
    }

    protected static <G extends GolemBase> void renderTexture(G entity, GolemModel<G> model, GolemRenderSettings settings, LayerRenderSettings layer, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, int packedOverlayIn) {
        int packedLight;
        matrixStackIn.m_85836_();
        ResourcePair texture = layer.getTexture();
        int n = packedLight = layer.getLight().orElse(settings.getBaseLight().orElse(false)) != false ? 0xF000F0 : packedLightIn;
        RenderType renderType = layer.isTranslucent() ? GolemRenderType.getGolemTranslucent(texture.resource(), layer.getTemplate(), !texture.flag()) : GolemRenderType.getGolemCutout(texture.resource(), layer.getTemplate(), !texture.flag());
        VertexConsumer vertexBuilder = bufferIn.m_6299_(renderType);
        if (layer.isTranslucent()) {
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        Vector3f colors = layer.getColor().isPresent() && layer.getColor().get() >= 0 ? GolemRenderSettings.unpackColor(layer.getColor().get()) : (settings.getBaseColor().isPresent() && settings.getBaseColor().get() >= 0 ? GolemRenderSettings.unpackColor(settings.getBaseColor().get()) : ONE);
        model.setColor(colors.x(), colors.y(), colors.z());
        model.m_7695_(matrixStackIn, vertexBuilder, packedLight, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        if (layer.isTranslucent()) {
            RenderSystem.m_69461_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrixStackIn.m_85849_();
    }
}

