/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.screen.guide_book;

import com.mcmoddev.golems.EGRegistry;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.GolemContainer;
import com.mcmoddev.golems.item.GuideBookItem;
import com.mcmoddev.golems.screen.guide_book.GolemBookEntry;
import com.mcmoddev.golems.screen.guide_book.button.BlockButton;
import com.mcmoddev.golems.screen.guide_book.button.GolemEntryButton;
import com.mcmoddev.golems.screen.guide_book.button.ScrollButton;
import com.mcmoddev.golems.screen.guide_book.module.DrawBlockModule;
import com.mcmoddev.golems.screen.guide_book.module.DrawDiagramPageModule;
import com.mcmoddev.golems.screen.guide_book.module.DrawEntryPageModule;
import com.mcmoddev.golems.screen.guide_book.module.DrawPageModule;
import com.mcmoddev.golems.screen.guide_book.module.DrawRecipePageModule;
import com.mcmoddev.golems.screen.guide_book.module.DrawTableOfContentsPageModule;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.block.Block;

public class GolemBookScreen
extends Screen
implements ScrollButton.IScrollListener {
    protected static final float GOLEM_BLOCK_SCALE = 1.6f;
    protected static final int MARGIN = 12;
    protected static final int INTRO_PAGE_COUNT = 6;
    protected static final int GOLEM_BOOK_ENTRY_COUNT = 5;
    protected static final int CONTENTS_WIDTH = 106;
    protected static final int CONTENTS_HEIGHT = 112;
    protected static final int SCROLL_X = 12;
    protected static final int SCROLL_Y = 24;
    protected static final ResourceLocation TEXTURE = new ResourceLocation("golems", "textures/gui/info_book.png");
    protected static final ResourceLocation CONTENTS = new ResourceLocation("golems", "textures/gui/info_book_contents.png");
    protected static final Component INTRO_TITLE = Component.m_237115_((String)"item.golems.info_book").m_130940_(ChatFormatting.ITALIC);
    protected static final Component INTRO_PAGE = Component.m_237115_((String)"golembook.intro1").m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"golembook.intro2"));
    protected static final Component CONTENTS_TITLE = Component.m_237115_((String)"golembook.contents.title").m_130940_(ChatFormatting.ITALIC);
    protected static final Component BUILD_GOLEM_TITLE = Component.m_237115_((String)"golembook.build_golem.title").m_130940_(ChatFormatting.ITALIC);
    protected static final Component BUILD_GOLEM_PAGE = Component.m_237115_((String)"golembook.build_golem.howto1").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"golembook.build_golem.howto2")).m_130946_("\n\n").m_7220_((Component)Component.m_237110_((String)"golembook.build_golem.howto3", (Object[])new Object[]{Component.m_237115_((String)"block.golems.golem_head")}));
    protected static final Component BUILD_HEAD_TITLE = Component.m_237115_((String)"block.golems.golem_head").m_130940_(ChatFormatting.ITALIC);
    protected static final Component BUILD_HEAD_PAGE = Component.m_237113_((String)"\n\n\n\n").m_7220_((Component)Component.m_237110_((String)"golembook.recipe_head.recipe", (Object[])new Object[]{BUILD_HEAD_TITLE, Component.m_237115_((String)"item.golems.golem_spell"), Component.m_237115_((String)"block.minecraft.pumpkin")}));
    protected static final Component BUILD_SPELL_TITLE = Component.m_237115_((String)"item.golems.golem_spell").m_130940_(ChatFormatting.ITALIC);
    protected static final Component BUILD_SPELL_PAGE = Component.m_237113_((String)"\n\n\n\n").m_7220_((Component)Component.m_237110_((String)"golembook.recipe_spell.recipe", (Object[])new Object[]{BUILD_SPELL_TITLE, Component.m_237115_((String)"item.minecraft.paper"), Component.m_237115_((String)"item.minecraft.feather"), Component.m_237115_((String)"item.minecraft.ink_sac"), Component.m_237115_((String)"item.minecraft.redstone")}));
    protected static final int BOOK_HEIGHT = 164;
    protected static final int BOOK_WIDTH = 256;
    protected static final int ENTRY_WIDTH = 88;
    protected static final int ENTRY_HEIGHT = 22;
    protected static final int ICON_SP = 5;
    protected static final int SCR_OFFSET_Y = 16;
    protected static final int ARROW_WIDTH = 18;
    protected static final int ARROW_HEIGHT = 10;
    protected static final int GOLEM_PAGE_IMAGE_WIDTH = 100;
    protected static final int GOLEM_PAGE_IMAGE_HEIGHT = 50;
    private Button doneBtn;
    private BlockButton leftBlockBtn;
    private BlockButton rightBlockBtn;
    private Button nextPageBtn;
    private Button prevPageBtn;
    private final GolemEntryButton[] tableOfContentsBtns;
    protected final List<GolemBookEntry> golemBookEntryList = new ArrayList<GolemBookEntry>();
    protected final List<Tuple<GolemBookEntry, Integer>> golemBookEntryListSorted = new ArrayList<Tuple<GolemBookEntry, Integer>>();
    protected int page;
    protected int totalPages;
    protected ScrollButton scrollButton;
    protected int scrollOffset;
    protected long ticksOpen;
    protected DrawBlockModule drawBlockModule;
    protected DrawEntryPageModule drawdrawEntryPageModule;
    protected DrawPageModule drawPageModule;
    protected DrawDiagramPageModule drawDiagramPageModule;
    protected DrawRecipePageModule drawRecipePageModule;
    protected DrawTableOfContentsPageModule drawTableOfContentsPageModule;
    private static final ResourceLocation SPELL_RECIPE = new ResourceLocation("golems", "golem_spell");
    private static final ResourceLocation HEAD_RECIPE = new ResourceLocation("golems", "golem_head");
    private final CraftingRecipe spellRecipe;
    private final CraftingRecipe headRecipe;

    public GolemBookScreen(Player playerIn, ItemStack itemIn) {
        super(((GuideBookItem)((Object)EGRegistry.INFO_BOOK.get())).m_41466_());
        this.initGolemBookEntries();
        this.spellRecipe = DrawRecipePageModule.loadRecipe(playerIn.f_19853_.m_7465_(), SPELL_RECIPE);
        this.headRecipe = DrawRecipePageModule.loadRecipe(playerIn.f_19853_.m_7465_(), HEAD_RECIPE);
        this.page = 0;
        this.totalPages = 6 + this.golemBookEntryList.size();
        this.tableOfContentsBtns = new GolemEntryButton[5];
        this.ticksOpen = 0L;
        this.scrollOffset = 0;
    }

    public void m_7856_() {
        this.drawBlockModule = new DrawBlockModule(this.f_96542_, 12);
        this.drawPageModule = new DrawPageModule(this.f_96547_, 256, 164, 12);
        this.drawDiagramPageModule = new DrawDiagramPageModule(this.drawBlockModule, this.f_96547_, 256, 164, 12);
        this.drawRecipePageModule = new DrawRecipePageModule(this.f_96547_, 256, 164, 12, this.f_96542_, CONTENTS, 84, 46, 111, 54);
        this.drawTableOfContentsPageModule = new DrawTableOfContentsPageModule(this.f_96547_, 256, 164, 12, CONTENTS, 0, 0, 106, 112);
        this.drawdrawEntryPageModule = new DrawEntryPageModule(this.f_96547_, 256, 164, 12, 100, 50);
        this.scrollButton = (ScrollButton)this.m_142416_((GuiEventListener)new ScrollButton(Button.m_253074_((Component)Component.m_237119_(), b -> {}).m_252794_(this.f_96543_ / 2 + 12 + 106 - 14, 40).m_253046_(12, 110), CONTENTS, 0, 115, 12, 15, 15, true, 1.0f / (float)(this.golemBookEntryList.size() - 5), this));
        int doneBtnWidth = 98;
        this.doneBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> this.f_96541_.m_91152_(null)).m_252794_((this.f_96543_ - doneBtnWidth) / 2, 188).m_253046_(98, 20).m_253136_());
        int arrowX = (this.f_96543_ - 256) / 2;
        int arrowY = 160;
        this.prevPageBtn = (Button)this.m_142416_((GuiEventListener)new ImageButton(arrowX + 18, arrowY, 18, 10, 23, 169, 10, TEXTURE, b -> this.addPage(-2)));
        this.nextPageBtn = (Button)this.m_142416_((GuiEventListener)new ImageButton(arrowX + 256 - 36, arrowY, 18, 10, 0, 169, 10, TEXTURE, b -> this.addPage(2)));
        int blockX = (this.f_96543_ - 256) / 2 + 12 + 4;
        int blockY = 28;
        this.leftBlockBtn = (BlockButton)this.m_142416_((GuiEventListener)new BlockButton(this, this.drawBlockModule, new Block[0], blockX, blockY, 12, 1.6f));
        blockX = this.f_96543_ / 2 + 12;
        this.rightBlockBtn = (BlockButton)this.m_142416_((GuiEventListener)new BlockButton(this, this.drawBlockModule, new Block[0], blockX, blockY, 12, 1.6f));
        int l = Math.min(5, this.golemBookEntryListSorted.size());
        int btnX = this.f_96543_ / 2 + 12;
        for (int i = 0; i < l; ++i) {
            Button.OnPress onPress = b -> {
                int page = ((GolemEntryButton)b).getPage();
                this.setPage(page);
                this.updateButtons();
            };
            int btnY = 40 + 22 * i;
            this.tableOfContentsBtns[i] = (GolemEntryButton)this.m_142416_((GuiEventListener)new GolemEntryButton(this, this.f_96547_, this.drawBlockModule, btnX, btnY, 88, 22, 12, CONTENTS, 111, 0, 22, this::getTicksOpen, onPress));
        }
        this.scrollButton.setScrollPercent(0.0f);
        this.updateButtons();
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.ticksOpen;
        if (this.leftBlockBtn != null) {
            this.leftBlockBtn.tick(this, (int)this.ticksOpen);
        }
        if (this.rightBlockBtn != null) {
            this.rightBlockBtn.tick(this, (int)this.ticksOpen);
        }
    }

    public long getTicksOpen() {
        return this.ticksOpen;
    }

    public void m_86412_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int bookX = (this.f_96543_ - 256) / 2;
        int bookY = 16;
        this.m_93228_(matrix, bookX, bookY, 0, 0, 256, 164);
        this.drawPageAt(matrix, bookX + 1, bookY, this.page, partialTicks);
        this.drawPageAt(matrix, bookX + 128 - 2, bookY, this.page + 1, partialTicks);
        super.m_86412_(matrix, mouseX, mouseY, partialTicks);
    }

    private void drawPageAt(PoseStack matrix, int cornerX, int cornerY, int pageNum, float partialTicks) {
        switch (pageNum) {
            case 0: {
                this.drawPageModule.withPage(pageNum).withTitle(INTRO_TITLE).withBody(INTRO_PAGE).withPos(cornerX, cornerY).render(this, matrix, partialTicks);
                return;
            }
            case 1: {
                this.drawTableOfContentsPageModule.withPage(pageNum).withTitle(CONTENTS_TITLE).withPos(cornerX, cornerY).render(this, matrix, partialTicks);
                return;
            }
            case 2: {
                this.drawRecipePageModule.withRecipe(this.spellRecipe).withTick((int)this.ticksOpen).withScale(1.0f).withPage(pageNum).withTitle(BUILD_SPELL_TITLE).withBody(BUILD_SPELL_PAGE).withPos(cornerX, cornerY).render(this, matrix, partialTicks);
                return;
            }
            case 3: {
                this.drawRecipePageModule.withRecipe(this.headRecipe).withTick((int)this.ticksOpen).withScale(1.0f).withPage(pageNum).withTitle(BUILD_HEAD_TITLE).withBody(BUILD_HEAD_PAGE).withPos(cornerX, cornerY).render(this, matrix, partialTicks);
                return;
            }
            case 4: {
                this.drawPageModule.withPage(pageNum).withTitle(BUILD_GOLEM_TITLE).withBody(BUILD_GOLEM_PAGE).withPos(cornerX, cornerY).render(this, matrix, partialTicks);
                return;
            }
            case 5: {
                this.drawDiagramPageModule.withPage(pageNum).withPos(cornerX, cornerY).render(this, matrix, partialTicks);
                return;
            }
        }
        if (GolemBookScreen.isPageGolemEntry(pageNum, this.totalPages)) {
            GolemBookEntry entry = this.getGolemEntryForPage(pageNum);
            this.drawdrawEntryPageModule.withEntry(entry).withPage(pageNum).withPos(cornerX, cornerY).render(this, matrix, partialTicks);
        }
    }

    protected void addPage(int pages) {
        this.page += pages;
        this.updateButtons();
    }

    protected void setPage(int page) {
        this.page = page;
        this.updateButtons();
    }

    protected void updateButtons() {
        this.prevPageBtn.f_93624_ = this.page > 0;
        this.nextPageBtn.f_93624_ = this.page + 2 < this.totalPages;
        boolean tableContentsVisible = GolemBookScreen.isPageTableContents(this.page);
        for (GolemEntryButton b : this.tableOfContentsBtns) {
            ((Button)b).f_93624_ = tableContentsVisible;
        }
        this.scrollButton.f_93624_ = tableContentsVisible;
        if (GolemBookScreen.isPageGolemEntry(this.page, this.totalPages)) {
            this.leftBlockBtn.f_93624_ = true;
            this.leftBlockBtn.updateBlocks(this.getGolemEntryForPage(this.page).getBlocks());
        } else {
            this.leftBlockBtn.f_93624_ = false;
        }
        if (GolemBookScreen.isPageGolemEntry(this.page + 1, this.totalPages)) {
            this.rightBlockBtn.f_93624_ = true;
            this.rightBlockBtn.updateBlocks(this.getGolemEntryForPage(this.page + 1).getBlocks());
        } else {
            this.rightBlockBtn.f_93624_ = false;
        }
    }

    private static boolean isPageGolemEntry(int page, int totalPages) {
        return page >= 6 && page < totalPages;
    }

    private static boolean isPageTableContents(int page) {
        return page >= 0 && page < 2;
    }

    public final void initGolemBookEntries() {
        this.golemBookEntryList.clear();
        Registry registry = Minecraft.m_91087_().f_91073_.m_8891_().m_175515_(ExtraGolems.Keys.GOLEM_CONTAINERS);
        for (Map.Entry entry : registry.m_6579_()) {
            if (((GolemContainer)entry.getValue()).isHidden()) continue;
            this.golemBookEntryList.add(new GolemBookEntry(((ResourceKey)entry.getKey()).m_135782_(), (GolemContainer)entry.getValue()));
        }
        Collections.sort(this.golemBookEntryList, (g1, g2) -> Float.compare(g1.getAttack(), g2.getAttack()));
        this.golemBookEntryListSorted.clear();
        ArrayList<GolemBookEntry> naturalOrderList = new ArrayList<GolemBookEntry>(this.golemBookEntryList);
        Collections.sort(naturalOrderList, Comparator.comparing(g -> g.getGolemName().getString()));
        for (GolemBookEntry entry : naturalOrderList) {
            int page = 6 + (this.golemBookEntryList.indexOf(entry) >> 1) * 2;
            this.golemBookEntryListSorted.add((Tuple<GolemBookEntry, Integer>)new Tuple((Object)entry, (Object)page));
        }
    }

    public GolemBookEntry getGolemEntryForPage(int page) {
        return this.golemBookEntryList.get(page - 6);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (GolemBookScreen.isPageTableContents(this.page)) {
            return this.scrollButton.m_6050_(mouseX, mouseY, amount);
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.scrollButton != null && this.scrollButton.isDragging()) {
            this.scrollButton.m_7212_(mouseX, mouseY, dragX, dragY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public void onScroll(ScrollButton button, float percent) {
        this.scrollOffset = Mth.m_14143_((float)(percent * (float)(this.golemBookEntryListSorted.size() - 5)));
        this.updateButtons();
        if (this.tableOfContentsBtns != null && this.tableOfContentsBtns.length > 0 && this.golemBookEntryListSorted.size() > 0) {
            int n = 5;
            for (int i = 0; i < n; ++i) {
                boolean outOfBounds;
                boolean bl = outOfBounds = n >= this.golemBookEntryListSorted.size();
                if (outOfBounds) {
                    this.tableOfContentsBtns[i].f_93624_ = false;
                    continue;
                }
                Tuple<GolemBookEntry, Integer> tuple = this.golemBookEntryListSorted.get(this.scrollOffset + i);
                this.tableOfContentsBtns[i].setEntry((GolemBookEntry)tuple.m_14418_(), (Integer)tuple.m_14419_());
            }
        }
    }
}

