/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.screen.guide_book.button;

import com.mcmoddev.golems.screen.guide_book.GolemBookEntry;
import com.mcmoddev.golems.screen.guide_book.module.DrawBlockModule;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class GolemEntryButton
extends ImageButton {
    protected final Screen parent;
    protected final DrawBlockModule drawBlockModule;
    protected final Font font;
    protected final int margin;
    protected final Supplier<Long> ticksOpenSupplier;
    protected GolemBookEntry entry;
    protected int page;

    public GolemEntryButton(Screen parent, Font font, DrawBlockModule drawBlockModule, int x, int y, int width, int height, int margin, ResourceLocation texture, int u, int v, int dv, Supplier<Long> ticksOpenSupplier, Button.OnPress onPress) {
        super(x, y, width, height, u, v, dv, texture, onPress);
        this.parent = parent;
        this.font = font;
        this.drawBlockModule = drawBlockModule;
        this.ticksOpenSupplier = ticksOpenSupplier;
        this.margin = margin;
        this.page = 0;
    }

    public void setEntry(GolemBookEntry entry, int page) {
        this.entry = entry;
        this.page = page;
    }

    public int getPage() {
        return this.page;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
        int index = (int)(this.ticksOpenSupplier.get() / 30L);
        this.drawBlockModule.withBlock(this.entry.getBlock(index)).withScale(1.0f).withPos(this.m_252754_() - this.margin - 2, this.m_252907_() - 9).render(this.parent, poseStack, partialTicks);
        poseStack.m_85836_();
        MutableComponent name = this.entry.getGolemName();
        int wrap = this.f_93618_ - 20;
        float scale = 1.0f;
        int nameH = this.font.m_92920_(name.getString(), wrap);
        if (nameH > this.f_93619_) {
            scale = 0.78f;
            nameH = (int)(scale * (float)this.font.m_92920_(name.getString(), (int)((float)wrap / scale)));
        }
        int nameX = this.m_252754_() + 20;
        int nameY = this.m_252907_() + (this.f_93619_ - nameH) / 2 + 1;
        poseStack.m_85841_(scale, scale, scale);
        for (FormattedCharSequence word : this.font.m_92923_((FormattedText)name, (int)((float)wrap / scale))) {
            this.font.m_92877_(poseStack, word, (float)nameX / scale, (float)nameY / scale, 0);
            Objects.requireNonNull(this.font);
            nameY += 9;
        }
        poseStack.m_85849_();
    }
}

