/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.screen.guide_book.module;

import com.mcmoddev.golems.screen.guide_book.GolemBookEntry;
import com.mcmoddev.golems.screen.guide_book.module.DrawPageModule;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class DrawEntryPageModule
extends DrawPageModule {
    protected final int imageWidth;
    protected final int imageHeight;
    protected GolemBookEntry entry;

    public DrawEntryPageModule(Font font, int width, int height, int margin, int imageWidth, int imageHeight) {
        super(font, width, height, margin);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    public DrawEntryPageModule withEntry(GolemBookEntry entry) {
        this.entry = entry;
        this.withTitle((Component)entry.getGolemName());
        return this;
    }

    @Override
    public void render(Screen parent, PoseStack poseStack, float partialTicks) {
        this.drawEntry(parent, poseStack);
        this.drawPageNum(poseStack);
    }

    protected void drawEntry(Screen parent, PoseStack poseStack) {
        int nameX = this.x + this.margin * 4;
        int nameY = this.y + this.margin;
        this.font.m_92857_((FormattedText)this.title, nameX, nameY, this.width / 2 - this.margin * 5, 0);
        int statsX = this.x + this.margin;
        int statsY = nameY + this.margin * 2;
        MutableComponent stats = this.entry.getDescriptionPage();
        this.font.m_92857_((FormattedText)stats, statsX, statsY, this.width / 2 - this.margin * 2, 0);
        if (this.entry.hasImage()) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 0.9f;
            int imgX = this.x + this.width / 4 - (int)((float)this.imageWidth * scale / 2.0f);
            int imgY = this.x + this.width - (int)((float)this.imageHeight * scale) - this.margin * 2;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.entry.getImageResource());
            int w = (int)((float)this.imageWidth * scale);
            int h = (int)((float)this.imageHeight * scale);
            Screen.m_93133_((PoseStack)poseStack, (int)imgX, (int)imgY, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
        }
    }
}

