/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.screen.guide_book.module;

import com.mcmoddev.golems.screen.guide_book.module.DrawModule;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class DrawPageModule
extends DrawModule {
    protected final Font font;
    protected final int width;
    protected final int height;
    protected final int margin;
    protected int page;
    protected int maxPages;
    protected Component title;
    protected Component body;

    public DrawPageModule(Font font, int width, int height, int margin) {
        this.font = font;
        this.width = width;
        this.height = height;
        this.margin = margin;
        this.page = 0;
        this.maxPages = 1;
        this.title = Component.m_237119_();
        this.body = Component.m_237119_();
    }

    public DrawPageModule withPage(int page, int maxPages) {
        this.page = page;
        this.maxPages = maxPages;
        return this;
    }

    public DrawPageModule withPage(int page) {
        this.page = page;
        return this;
    }

    public DrawPageModule withTitle(Component title) {
        this.title = title;
        return this;
    }

    public DrawPageModule withBody(Component body) {
        this.body = body;
        return this;
    }

    @Override
    public void render(Screen parent, PoseStack poseStack, float partialTicks) {
        this.drawBasicPage(poseStack, this.title, this.body);
        this.drawPageNum(poseStack);
    }

    protected void drawPageNum(PoseStack poseStack) {
        boolean isRight = this.page % 2 == 1;
        int posX = isRight ? this.x + this.margin * 2 : this.x + this.width / 2 - this.margin * 2;
        int posY = this.y + this.height - 18;
        String sPage = String.valueOf(this.page + 1);
        int sWidth = isRight ? this.font.m_92895_(sPage) : 0;
        this.font.m_92883_(poseStack, sPage, (float)(posX - sWidth), (float)posY, 0);
    }

    protected void drawBasicPage(PoseStack poseStack, Component title, Component body) {
        int maxWidth = this.width / 2 - this.margin * 2;
        int titleX = this.x + this.margin + 4;
        int titleY = this.y + this.margin;
        int sWidth = this.font.m_92895_(title.getString());
        if (sWidth > maxWidth) {
            this.font.m_92857_((FormattedText)title, titleX, titleY, maxWidth, 0);
        } else {
            this.font.m_92883_(poseStack, title.getString(), (float)titleX + (float)(maxWidth - sWidth) / 2.0f, (float)titleY, 0);
        }
        int bodyX = titleX;
        int bodyY = titleY + this.margin * 2;
        this.font.m_92857_((FormattedText)body, bodyX, bodyY, maxWidth, 0);
    }
}

