/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.screen.guide_book.module;

import com.mcmoddev.golems.screen.guide_book.module.DrawPageModule;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;

public class DrawRecipePageModule
extends DrawPageModule {
    protected final ItemRenderer itemRenderer;
    protected final ResourceLocation texture;
    protected final int imageWidth;
    protected final int imageHeight;
    protected final int u;
    protected final int v;
    protected float scale;
    protected CraftingRecipe recipe;
    protected ItemStack[] ingredients;

    public DrawRecipePageModule(Font font, int width, int height, int margin, ItemRenderer itemRenderer, ResourceLocation texture, int imageWidth, int imageHeight, int u, int v) {
        super(font, width, height, margin);
        this.itemRenderer = itemRenderer;
        this.texture = texture;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.u = u;
        this.v = v;
        this.scale = 1.0f;
        this.ingredients = (ItemStack[])NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_).toArray((Object[])new ItemStack[4]);
    }

    public DrawRecipePageModule withRecipe(RecipeManager recipeManager, ResourceLocation recipe) {
        return this.withRecipe(DrawRecipePageModule.loadRecipe(recipeManager, recipe));
    }

    public DrawRecipePageModule withRecipe(CraftingRecipe recipe) {
        this.recipe = recipe;
        for (int i = 0; i < 4; ++i) {
            this.ingredients[i] = ItemStack.f_41583_;
        }
        return this.withTick(0);
    }

    public DrawRecipePageModule withScale(float scale) {
        this.scale = scale;
        return this;
    }

    @Nullable
    public static CraftingRecipe loadRecipe(RecipeManager recipeManager, ResourceLocation recipe) {
        CraftingRecipe craftingRecipe;
        Object t;
        Optional oRecipe = recipeManager.m_44043_(recipe);
        if (oRecipe.isPresent() && (t = oRecipe.get()) instanceof CraftingRecipe && (craftingRecipe = (CraftingRecipe)t).m_8004_(2, 2)) {
            return craftingRecipe;
        }
        return null;
    }

    public DrawRecipePageModule withTick(int ticksOpen) {
        if (this.recipe != null) {
            NonNullList recipeIngredients = this.recipe.m_7527_();
            for (int i = 0; i < 4; ++i) {
                if (i >= recipeIngredients.size()) {
                    this.ingredients[i] = ItemStack.f_41583_;
                    continue;
                }
                ItemStack[] items = ((Ingredient)recipeIngredients.get(i)).m_43908_();
                this.ingredients[i] = items[ticksOpen / 30 % items.length];
            }
        }
        return this;
    }

    @Override
    public void render(Screen parent, PoseStack poseStack, float partialTicks) {
        this.drawBasicPage(poseStack, this.title, this.body);
        this.drawRecipe(parent, poseStack);
        this.drawPageNum(poseStack);
    }

    protected void drawRecipe(Screen parent, PoseStack matrix) {
        float posY;
        float posX;
        int startX = this.x + this.margin * 2;
        int startY = this.y + this.margin * 2;
        int frameWidth = 3;
        matrix.m_85836_();
        matrix.m_85841_(this.scale, this.scale, this.scale);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        parent.m_93228_(matrix, startX, startY, this.u, this.v, this.imageWidth, this.imageHeight);
        if (null == this.recipe) {
            return;
        }
        Lighting.m_84930_();
        int iconW = 15;
        switch (this.recipe.m_7527_().size()) {
            case 4: {
                posX = (float)(startX + iconW) + 9.0f;
                posY = (float)(startY + iconW) + 9.0f;
                this.itemRenderer.m_115123_(this.ingredients[3], (int)(posX / this.scale), (int)(posY / this.scale));
            }
            case 3: {
                posX = (float)startX + 6.0f;
                posY = (float)(startY + iconW) + 9.0f;
                this.itemRenderer.m_115123_(this.ingredients[2], (int)(posX / this.scale), (int)(posY / this.scale));
            }
            case 2: {
                posX = (float)(startX + iconW) + 9.0f;
                posY = (float)startY + 6.0f;
                this.itemRenderer.m_115123_(this.ingredients[1], (int)(posX / this.scale), (int)(posY / this.scale));
            }
            case 1: {
                posX = (float)startX + 6.0f;
                posY = (float)startY + 6.0f;
                this.itemRenderer.m_115123_(this.ingredients[0], (int)(posX / this.scale), (int)(posY / this.scale));
            }
        }
        posX = (float)(startX + this.imageWidth) - 16.0f - 6.0f;
        posY = (float)startY + 16.0f;
        this.itemRenderer.m_115123_(this.recipe.m_8043_(), (int)(posX / this.scale), (int)(posY / this.scale));
        this.itemRenderer.m_115169_(this.font, this.recipe.m_8043_(), (int)(posX / this.scale), (int)(posY / this.scale));
        matrix.m_85849_();
    }
}

