/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.util;

import com.mcmoddev.golems.EGRegistry;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.GolemContainer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;

public final class GolemAttributes {
    private static final Map<ResourceLocation, AttributeSupplier> materialToAttributeMap = new HashMap<ResourceLocation, AttributeSupplier>();

    public static AttributeMap getAttributes(RegistryAccess access, ResourceLocation material) {
        if (!materialToAttributeMap.containsKey(material)) {
            Registry registry = access.m_175515_(ExtraGolems.Keys.GOLEM_CONTAINERS);
            GolemContainer container = registry.m_6612_(material).orElse(GolemContainer.EMPTY);
            AttributeSupplier supplier = GolemAttributes.buildAttributes(container.getAttributeSupplier().get());
            materialToAttributeMap.put(material, supplier);
        }
        return new AttributeMap(materialToAttributeMap.get(material));
    }

    private static AttributeSupplier buildAttributes(AttributeSupplier.Builder materialAttributes) {
        AttributeSupplier master = DefaultAttributes.m_22297_((EntityType)((EntityType)EGRegistry.GOLEM.get()));
        AttributeSupplier.Builder builder = new AttributeSupplier.Builder(master);
        builder.combine(materialAttributes);
        return builder.m_22265_();
    }

    public static void clear() {
        materialToAttributeMap.clear();
    }
}

