/*
 * Decompiled with CFR 0.152.
 */
package net.misterslime.fabulousclouds.clouds;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3541;
import net.minecraft.class_5819;
import net.misterslime.fabulousclouds.clouds.SkyCoverGenerators;
import net.misterslime.fabulousclouds.util.EnumUtil;

public class CloudTexture {
    public List<PixelCoordinate> pixels = new LinkedList<PixelCoordinate>(){};
    public class_3541 noise;
    public class_1043 cloudsTexture;
    public class_2960 resourceLocation;
    public double cloudiness;
    private SkyCoverTypes skyCover;

    public CloudTexture(class_2960 resourceLocation) {
        this.resourceLocation = resourceLocation;
        this.randomizeSkyCover();
    }

    public void updateImage(long time) {
        Random random = new Random(time);
        switch (this.skyCover) {
            case CLEAR: {
                SkyCoverGenerators.clearSkyUpdate(random, this.noise, this.cloudsTexture.method_4525(), this.pixels, this.cloudiness);
                break;
            }
            case NORMAL: {
                SkyCoverGenerators.normalSkyUpdate(random, this.noise, this.cloudsTexture.method_4525(), this.pixels, this.cloudiness);
                break;
            }
            case CLOUDY: {
                SkyCoverGenerators.cloudySkyUpdate(random, this.noise, this.cloudsTexture.method_4525(), this.pixels, this.cloudiness);
            }
        }
    }

    public void updatePixels() {
        this.pixels.removeIf(pixel -> !this.fadePixel(Objects.requireNonNull(this.cloudsTexture.method_4525()), pixel.posX, pixel.posZ, pixel.fading));
        this.cloudsTexture.method_4524();
    }

    public boolean fadePixel(class_1011 image, int x, int z, boolean fading) {
        int color = image.method_4315(x, z);
        int alpha = color >> 24 & 0xFF;
        alpha = fading ? (alpha -= 5) : (alpha += 5);
        int newColor = alpha << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        image.method_4305(x, z, newColor);
        if (alpha <= 0) {
            image.method_4305(x, z, 0);
            return false;
        }
        return alpha < 255;
    }

    public void setTexture(class_1043 texture) {
        this.cloudsTexture = texture;
    }

    public void initNoise(Random random) {
        this.noise = new class_3541((class_5819)new class_2919(random.nextLong()));
    }

    public class_1043 getNativeImage() {
        class_1011 image = new class_1011(256, 256, false);
        Random random = new Random();
        this.cloudiness = random.nextDouble();
        switch (this.skyCover) {
            case CLEAR: {
                SkyCoverGenerators.clearSkyGenerator(this.noise, image, this.cloudiness);
                break;
            }
            case NORMAL: {
                SkyCoverGenerators.normalSkyGenerator(this.noise, image, this.cloudiness);
                break;
            }
            case CLOUDY: {
                SkyCoverGenerators.cloudySkyGenerator(this.noise, image, this.cloudiness);
            }
        }
        return new class_1043(image);
    }

    public void randomizeSkyCover() {
        this.skyCover = EnumUtil.randomEnum(SkyCoverTypes.class);
    }

    public static enum SkyCoverTypes {
        NORMAL,
        CLOUDY,
        CLEAR;

    }

    public static class PixelCoordinate {
        public int posX;
        public int posZ;
        public boolean fading;

        public PixelCoordinate(int posX, int posZ, boolean fading) {
            this.posX = posX;
            this.posZ = posZ;
            this.fading = fading;
        }
    }
}

