/*
 * Decompiled with CFR 0.152.
 */
package net.misterslime.fabulousclouds.mixin;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1159;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4063;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_761;
import net.misterslime.fabulousclouds.FabulousClouds;
import net.misterslime.fabulousclouds.NoiseCloudHandler;
import net.misterslime.fabulousclouds.clouds.CloudTexture;
import net.misterslime.fabulousclouds.config.FabulousCloudsConfig;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public final class MixinLevelRenderer {
    @Final
    @Shadow
    private static class_2960 field_4108;
    @Shadow
    private final int field_4073;
    @Final
    @Shadow
    @NotNull
    private final class_310 field_4088 = class_310.method_1551();
    @Shadow
    private int field_4082;
    @Shadow
    private int field_4097;
    @Shadow
    private int field_4116;
    @Shadow
    @NotNull
    private class_243 field_4072;
    @Shadow
    @NotNull
    private class_4063 field_4080;
    @Shadow
    private boolean field_4107;
    @Shadow
    @NotNull
    private class_291 field_4094;
    @Unique
    private boolean initializedClouds = false;

    public MixinLevelRenderer() {
        throw new NullPointerException("Null cannot be cast to non-null type.");
    }

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderClouds(class_4587 poseStack, class_1159 model, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        FabulousCloudsConfig config = FabulousClouds.getConfig();
        if (FabulousClouds.getConfig().noise_clouds) {
            class_1060 textureManager = class_310.method_1551().method_1531();
            this.registerClouds(textureManager);
            NoiseCloudHandler.update();
        }
        if (this.field_4088.field_1687.method_27983() == class_638.field_25179) {
            float cloudHeight = 128.0f;
            if (!Float.isNaN(cloudHeight)) {
                int i = 0;
                for (FabulousCloudsConfig.CloudLayer cloudLayer : config.cloud_layers) {
                    CloudTexture cloudTexture = NoiseCloudHandler.cloudTextures.get(i);
                    this.renderCloudLayer(poseStack, model, tickDelta, cameraX, cameraY, cameraZ, cloudHeight, cloudLayer.offset, cloudLayer.scale, cloudLayer.speed, cloudTexture.resourceLocation);
                    ++i;
                }
            }
            if (config.enable_default_cloud_layer) {
                CloudTexture cloudTexture = NoiseCloudHandler.cloudTextures.get(NoiseCloudHandler.cloudTextures.size() - 1);
                this.renderCloudLayer(poseStack, model, tickDelta, cameraX, cameraY, cameraZ, cloudHeight, 0.0f, 1.0f, 1.0f, cloudTexture.resourceLocation);
            }
            ci.cancel();
        }
    }

    private void registerClouds(class_1060 textureManager) {
        if (!this.initializedClouds) {
            Random random = new Random();
            NoiseCloudHandler.initCloudTextures(field_4108);
            for (CloudTexture cloudTexture : NoiseCloudHandler.cloudTextures) {
                cloudTexture.initNoise(random);
                class_1043 texture = cloudTexture.getNativeImage();
                textureManager.method_4616(cloudTexture.resourceLocation, (class_1044)texture);
                cloudTexture.setTexture(texture);
            }
            this.initializedClouds = true;
        }
    }

    private void renderCloudLayer(class_4587 poseStack, class_1159 model, float tickDelta, double cameraX, double cameraY, double cameraZ, float cloudHeight, float cloudOffset, float cloudScale, float speedMod, class_2960 resourceLocation) {
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask((boolean)true);
        float scale = 12.0f * cloudScale;
        double speed = ((float)this.field_4073 + tickDelta) * (0.03f * speedMod);
        double posX = (cameraX + speed) / (double)scale;
        double posY = (cloudHeight - (float)cameraY + cloudOffset) / cloudScale;
        double posZ = cameraZ / (double)scale + (double)0.33f;
        posX -= Math.floor(posX / 2048.0) * 2048.0;
        posZ -= Math.floor(posZ / 2048.0) * 2048.0;
        float adjustedX = (float)(posX - Math.floor(posX));
        float adjustedY = (float)(posY / 4.0 - Math.floor(posY / 4.0)) * 4.0f;
        float adjustedZ = (float)(posZ - Math.floor(posZ));
        class_243 cloudColor = this.field_4088.field_1687.method_23785(tickDelta);
        int floorX = (int)Math.floor(posX);
        int floorY = (int)Math.floor(posY / 4.0);
        int floorZ = (int)Math.floor(posZ);
        if (floorX != this.field_4082 || floorY != this.field_4097 || floorZ != this.field_4116 || this.field_4088.field_1690.method_1632() != this.field_4080 || this.field_4072.method_1025(cloudColor) > 2.0E-4) {
            this.field_4082 = floorX;
            this.field_4097 = floorY;
            this.field_4116 = floorZ;
            this.field_4072 = cloudColor;
            this.field_4080 = this.field_4088.field_1690.method_1632();
            this.field_4107 = true;
        }
        if (this.field_4107) {
            this.field_4107 = false;
            class_289 tessellator = class_289.method_1348();
            class_287 bufferBuilder = tessellator.method_1349();
            if (this.field_4094 != null) {
                this.field_4094.close();
            }
            this.field_4094 = new class_291();
            this.buildCloudLayer(bufferBuilder, posX, posY, posZ, cloudScale, cloudColor);
            bufferBuilder.method_1326();
            this.field_4094.method_1352(bufferBuilder);
        }
        RenderSystem.setShader(class_757::method_34549);
        RenderSystem.setShaderTexture((int)0, (class_2960)resourceLocation);
        class_758.method_3212();
        poseStack.method_22903();
        poseStack.method_22905(scale, cloudScale, scale);
        poseStack.method_22904((double)(-adjustedX), (double)adjustedY, (double)(-adjustedZ));
        if (this.field_4094 != null) {
            int cloudIndex = 1;
            for (int cloudMainIndex = this.field_4080 == class_4063.field_18164 ? 0 : 1; cloudMainIndex <= cloudIndex; ++cloudMainIndex) {
                if (cloudMainIndex == 0) {
                    RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                } else {
                    RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                }
                class_5944 shader = RenderSystem.getShader();
                this.field_4094.method_34427(poseStack.method_23760().method_23761(), model, shader);
            }
        }
        poseStack.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    private void buildCloudLayer(class_287 bufferBuilder, double x, double y, double z, float scale, class_243 color) {
        float f = 4.0f;
        float f2 = 0.00390625f;
        int n = 8;
        int n2 = 4;
        float f3 = 9.765625E-4f;
        float f4 = (float)Math.floor(x) * 0.00390625f;
        float f5 = (float)Math.floor(z) * 0.00390625f;
        float f6 = (float)color.field_1352;
        float f7 = (float)color.field_1351;
        float f8 = (float)color.field_1350;
        float f9 = f6 * 0.9f;
        float f10 = f7 * 0.9f;
        float f11 = f8 * 0.9f;
        float f12 = f6 * 0.7f;
        float f13 = f7 * 0.7f;
        float f14 = f8 * 0.7f;
        float f15 = f6 * 0.8f;
        float f16 = f7 * 0.8f;
        float f17 = f8 * 0.8f;
        RenderSystem.setShader(class_757::method_34549);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1577);
        float f18 = (float)Math.floor(y / 4.0) * 4.0f;
        if (this.field_4080 == class_4063.field_18164) {
            int i2 = (int)(8.0f / scale) / 2;
            for (int i = -i2 + 1; i <= i2; ++i) {
                for (int j = -i2 + 1; j <= i2; ++j) {
                    int n3;
                    float f19 = i * 8;
                    float f20 = j * 8;
                    if (f18 > -5.0f) {
                        bufferBuilder.method_22912((double)(f19 + 0.0f), (double)(f18 + 0.0f), (double)(f20 + 8.0f)).method_22913((f19 + 0.0f) * 0.00390625f + f4, (f20 + 8.0f) * 0.00390625f + f5).method_22915(f12, f13, f14, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                        bufferBuilder.method_22912((double)(f19 + 8.0f), (double)(f18 + 0.0f), (double)(f20 + 8.0f)).method_22913((f19 + 8.0f) * 0.00390625f + f4, (f20 + 8.0f) * 0.00390625f + f5).method_22915(f12, f13, f14, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                        bufferBuilder.method_22912((double)(f19 + 8.0f), (double)(f18 + 0.0f), (double)(f20 + 0.0f)).method_22913((f19 + 8.0f) * 0.00390625f + f4, (f20 + 0.0f) * 0.00390625f + f5).method_22915(f12, f13, f14, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                        bufferBuilder.method_22912((double)(f19 + 0.0f), (double)(f18 + 0.0f), (double)(f20 + 0.0f)).method_22913((f19 + 0.0f) * 0.00390625f + f4, (f20 + 0.0f) * 0.00390625f + f5).method_22915(f12, f13, f14, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                    }
                    if (f18 <= 5.0f) {
                        bufferBuilder.method_22912((double)(f19 + 0.0f), (double)(f18 + 4.0f - 9.765625E-4f), (double)(f20 + 8.0f)).method_22913((f19 + 0.0f) * 0.00390625f + f4, (f20 + 8.0f) * 0.00390625f + f5).method_22915(f6, f7, f8, 0.8f).method_22914(0.0f, 1.0f, 0.0f).method_1344();
                        bufferBuilder.method_22912((double)(f19 + 8.0f), (double)(f18 + 4.0f - 9.765625E-4f), (double)(f20 + 8.0f)).method_22913((f19 + 8.0f) * 0.00390625f + f4, (f20 + 8.0f) * 0.00390625f + f5).method_22915(f6, f7, f8, 0.8f).method_22914(0.0f, 1.0f, 0.0f).method_1344();
                        bufferBuilder.method_22912((double)(f19 + 8.0f), (double)(f18 + 4.0f - 9.765625E-4f), (double)(f20 + 0.0f)).method_22913((f19 + 8.0f) * 0.00390625f + f4, (f20 + 0.0f) * 0.00390625f + f5).method_22915(f6, f7, f8, 0.8f).method_22914(0.0f, 1.0f, 0.0f).method_1344();
                        bufferBuilder.method_22912((double)(f19 + 0.0f), (double)(f18 + 4.0f - 9.765625E-4f), (double)(f20 + 0.0f)).method_22913((f19 + 0.0f) * 0.00390625f + f4, (f20 + 0.0f) * 0.00390625f + f5).method_22915(f6, f7, f8, 0.8f).method_22914(0.0f, 1.0f, 0.0f).method_1344();
                    }
                    if (i > -1) {
                        for (n3 = 0; n3 < 8; ++n3) {
                            bufferBuilder.method_22912((double)(f19 + (float)n3 + 0.0f), (double)(f18 + 0.0f), (double)(f20 + 8.0f)).method_22913((f19 + (float)n3 + 0.5f) * 0.00390625f + f4, (f20 + 8.0f) * 0.00390625f + f5).method_22915(f9, f10, f11, 0.8f).method_22914(-1.0f, 0.0f, 0.0f).method_1344();
                            bufferBuilder.method_22912((double)(f19 + (float)n3 + 0.0f), (double)(f18 + 4.0f), (double)(f20 + 8.0f)).method_22913((f19 + (float)n3 + 0.5f) * 0.00390625f + f4, (f20 + 8.0f) * 0.00390625f + f5).method_22915(f9, f10, f11, 0.8f).method_22914(-1.0f, 0.0f, 0.0f).method_1344();
                            bufferBuilder.method_22912((double)(f19 + (float)n3 + 0.0f), (double)(f18 + 4.0f), (double)(f20 + 0.0f)).method_22913((f19 + (float)n3 + 0.5f) * 0.00390625f + f4, (f20 + 0.0f) * 0.00390625f + f5).method_22915(f9, f10, f11, 0.8f).method_22914(-1.0f, 0.0f, 0.0f).method_1344();
                            bufferBuilder.method_22912((double)(f19 + (float)n3 + 0.0f), (double)(f18 + 0.0f), (double)(f20 + 0.0f)).method_22913((f19 + (float)n3 + 0.5f) * 0.00390625f + f4, (f20 + 0.0f) * 0.00390625f + f5).method_22915(f9, f10, f11, 0.8f).method_22914(-1.0f, 0.0f, 0.0f).method_1344();
                        }
                    }
                    if (i <= 1) {
                        for (n3 = 0; n3 < 8; ++n3) {
                            bufferBuilder.method_22912((double)(f19 + (float)n3 + 1.0f - 9.765625E-4f), (double)(f18 + 0.0f), (double)(f20 + 8.0f)).method_22913((f19 + (float)n3 + 0.5f) * 0.00390625f + f4, (f20 + 8.0f) * 0.00390625f + f5).method_22915(f9, f10, f11, 0.8f).method_22914(1.0f, 0.0f, 0.0f).method_1344();
                            bufferBuilder.method_22912((double)(f19 + (float)n3 + 1.0f - 9.765625E-4f), (double)(f18 + 4.0f), (double)(f20 + 8.0f)).method_22913((f19 + (float)n3 + 0.5f) * 0.00390625f + f4, (f20 + 8.0f) * 0.00390625f + f5).method_22915(f9, f10, f11, 0.8f).method_22914(1.0f, 0.0f, 0.0f).method_1344();
                            bufferBuilder.method_22912((double)(f19 + (float)n3 + 1.0f - 9.765625E-4f), (double)(f18 + 4.0f), (double)(f20 + 0.0f)).method_22913((f19 + (float)n3 + 0.5f) * 0.00390625f + f4, (f20 + 0.0f) * 0.00390625f + f5).method_22915(f9, f10, f11, 0.8f).method_22914(1.0f, 0.0f, 0.0f).method_1344();
                            bufferBuilder.method_22912((double)(f19 + (float)n3 + 1.0f - 9.765625E-4f), (double)(f18 + 0.0f), (double)(f20 + 0.0f)).method_22913((f19 + (float)n3 + 0.5f) * 0.00390625f + f4, (f20 + 0.0f) * 0.00390625f + f5).method_22915(f9, f10, f11, 0.8f).method_22914(1.0f, 0.0f, 0.0f).method_1344();
                        }
                    }
                    if (j > -1) {
                        for (n3 = 0; n3 < 8; ++n3) {
                            bufferBuilder.method_22912((double)(f19 + 0.0f), (double)(f18 + 4.0f), (double)(f20 + (float)n3 + 0.0f)).method_22913((f19 + 0.0f) * 0.00390625f + f4, (f20 + (float)n3 + 0.5f) * 0.00390625f + f5).method_22915(f15, f16, f17, 0.8f).method_22914(0.0f, 0.0f, -1.0f).method_1344();
                            bufferBuilder.method_22912((double)(f19 + 8.0f), (double)(f18 + 4.0f), (double)(f20 + (float)n3 + 0.0f)).method_22913((f19 + 8.0f) * 0.00390625f + f4, (f20 + (float)n3 + 0.5f) * 0.00390625f + f5).method_22915(f15, f16, f17, 0.8f).method_22914(0.0f, 0.0f, -1.0f).method_1344();
                            bufferBuilder.method_22912((double)(f19 + 8.0f), (double)(f18 + 0.0f), (double)(f20 + (float)n3 + 0.0f)).method_22913((f19 + 8.0f) * 0.00390625f + f4, (f20 + (float)n3 + 0.5f) * 0.00390625f + f5).method_22915(f15, f16, f17, 0.8f).method_22914(0.0f, 0.0f, -1.0f).method_1344();
                            bufferBuilder.method_22912((double)(f19 + 0.0f), (double)(f18 + 0.0f), (double)(f20 + (float)n3 + 0.0f)).method_22913((f19 + 0.0f) * 0.00390625f + f4, (f20 + (float)n3 + 0.5f) * 0.00390625f + f5).method_22915(f15, f16, f17, 0.8f).method_22914(0.0f, 0.0f, -1.0f).method_1344();
                        }
                    }
                    if (j > 1) continue;
                    for (n3 = 0; n3 < 8; ++n3) {
                        bufferBuilder.method_22912((double)(f19 + 0.0f), (double)(f18 + 4.0f), (double)(f20 + (float)n3 + 1.0f - 9.765625E-4f)).method_22913((f19 + 0.0f) * 0.00390625f + f4, (f20 + (float)n3 + 0.5f) * 0.00390625f + f5).method_22915(f15, f16, f17, 0.8f).method_22914(0.0f, 0.0f, 1.0f).method_1344();
                        bufferBuilder.method_22912((double)(f19 + 8.0f), (double)(f18 + 4.0f), (double)(f20 + (float)n3 + 1.0f - 9.765625E-4f)).method_22913((f19 + 8.0f) * 0.00390625f + f4, (f20 + (float)n3 + 0.5f) * 0.00390625f + f5).method_22915(f15, f16, f17, 0.8f).method_22914(0.0f, 0.0f, 1.0f).method_1344();
                        bufferBuilder.method_22912((double)(f19 + 8.0f), (double)(f18 + 0.0f), (double)(f20 + (float)n3 + 1.0f - 9.765625E-4f)).method_22913((f19 + 8.0f) * 0.00390625f + f4, (f20 + (float)n3 + 0.5f) * 0.00390625f + f5).method_22915(f15, f16, f17, 0.8f).method_22914(0.0f, 0.0f, 1.0f).method_1344();
                        bufferBuilder.method_22912((double)(f19 + 0.0f), (double)(f18 + 0.0f), (double)(f20 + (float)n3 + 1.0f - 9.765625E-4f)).method_22913((f19 + 0.0f) * 0.00390625f + f4, (f20 + (float)n3 + 0.5f) * 0.00390625f + f5).method_22915(f15, f16, f17, 0.8f).method_22914(0.0f, 0.0f, 1.0f).method_1344();
                    }
                }
            }
        } else {
            boolean bl = true;
            int n4 = (int)(32.0f / scale);
            for (int i = -n4; i < n4; i += n4) {
                for (int j = -n4; j < n4; j += n4) {
                    bufferBuilder.method_22912((double)(i + 0), (double)f18, (double)(j + n4)).method_22913((float)(i + 0) * 0.00390625f + f4, (float)(j + n4) * 0.00390625f + f5).method_22915(f6, f7, f8, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                    bufferBuilder.method_22912((double)(i + n4), (double)f18, (double)(j + n4)).method_22913((float)(i + n4) * 0.00390625f + f4, (float)(j + n4) * 0.00390625f + f5).method_22915(f6, f7, f8, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                    bufferBuilder.method_22912((double)(i + n4), (double)f18, (double)(j + 0)).method_22913((float)(i + n4) * 0.00390625f + f4, (float)(j + 0) * 0.00390625f + f5).method_22915(f6, f7, f8, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                    bufferBuilder.method_22912((double)(i + 0), (double)f18, (double)(j + 0)).method_22913((float)(i + 0) * 0.00390625f + f4, (float)(j + 0) * 0.00390625f + f5).method_22915(f6, f7, f8, 0.8f).method_22914(0.0f, -1.0f, 0.0f).method_1344();
                }
            }
        }
    }
}

