/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.feders_scarecrows.common.entities;

import com.itayfeder.feders_scarecrows.common.entities.Scarecrow;
import com.itayfeder.feders_scarecrows.init.EntityTypeInit;
import com.itayfeder.feders_scarecrows.init.ItemInit;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TemplateScarecrow
extends LivingEntity {
    public static final int WOBBLE_TIME = 5;
    private static final EntityDimensions MARKER_DIMENSIONS = new EntityDimensions(0.0f, 0.0f, true);
    private static final EntityDimensions BABY_DIMENSIONS = EntityTypeInit.SCARECROW.m_20680_().m_20388_(0.5f);
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS = SynchedEntityData.m_135353_(Scarecrow.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final Predicate<Entity> RIDABLE_MINECARTS = p_31582_ -> p_31582_ instanceof AbstractMinecart && ((AbstractMinecart)p_31582_).canBeRidden();
    private boolean invisible;
    public long lastHit;
    private final NonNullList<ItemStack> handItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);

    public TemplateScarecrow(EntityType<? extends TemplateScarecrow> p_31553_, Level p_31554_) {
        super(p_31553_, p_31554_);
        this.f_19793_ = 0.0f;
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.m_20068_();
    }

    public boolean m_6142_() {
        return super.m_6142_() && this.hasPhysics();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CLIENT_FLAGS, (Object)0);
    }

    public void m_7380_(CompoundTag p_31619_) {
        super.m_7380_(p_31619_);
        p_31619_.m_128379_("Invisible", this.m_20145_());
        p_31619_.m_128379_("Small", this.isSmall());
        if (this.isMarker()) {
            p_31619_.m_128379_("Marker", this.isMarker());
        }
    }

    public void m_7378_(CompoundTag p_31600_) {
        super.m_7378_(p_31600_);
        this.m_6842_(p_31600_.m_128471_("Invisible"));
        this.setSmall(p_31600_.m_128471_("Small"));
        this.setMarker(p_31600_.m_128471_("Marker"));
        this.f_19794_ = !this.hasPhysics();
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity p_31564_) {
    }

    protected void m_6138_() {
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_(), RIDABLE_MINECARTS);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(this.m_20280_(entity) <= 0.2)) continue;
            entity.m_7334_((Entity)this);
        }
    }

    public InteractionResult m_7111_(Player p_31594_, Vec3 p_31595_, InteractionHand p_31596_) {
        return InteractionResult.PASS;
    }

    public boolean m_6469_(DamageSource p_31579_, float p_31580_) {
        if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
            if (DamageSource.f_19317_.equals(p_31579_)) {
                this.m_6074_();
                return false;
            }
            if (!(this.m_6673_(p_31579_) || this.invisible || this.isMarker())) {
                if (p_31579_.m_19372_()) {
                    this.brokenByAnything(p_31579_);
                    this.m_6074_();
                    return false;
                }
                if (DamageSource.f_19305_.equals(p_31579_)) {
                    if (this.m_6060_()) {
                        this.causeDamage(p_31579_, 0.15f);
                    } else {
                        this.m_20254_(5);
                    }
                    return false;
                }
                if (DamageSource.f_19307_.equals(p_31579_) && this.m_21223_() > 0.5f) {
                    this.causeDamage(p_31579_, 4.0f);
                    return false;
                }
                boolean flag = p_31579_.m_7640_() instanceof AbstractArrow;
                boolean flag1 = flag && ((AbstractArrow)p_31579_.m_7640_()).m_36796_() > 0;
                boolean flag2 = "player".equals(p_31579_.m_19385_());
                if (!flag2 && !flag) {
                    return false;
                }
                if (p_31579_.m_7639_() instanceof Player && !((Player)p_31579_.m_7639_()).m_150110_().f_35938_) {
                    return false;
                }
                if (p_31579_.m_19390_()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.m_6074_();
                    return flag1;
                }
                long i = this.f_19853_.m_46467_();
                if (i - this.lastHit > 5L && !flag) {
                    this.f_19853_.m_7605_((Entity)this, (byte)32);
                    this.m_146852_(GameEvent.f_157808_, p_31579_.m_7639_());
                    this.lastHit = i;
                } else {
                    this.brokenByPlayer(p_31579_);
                    this.showBreakingParticles();
                    this.m_6074_();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void m_7822_(byte p_31568_) {
        if (p_31568_ == 32) {
            if (this.f_19853_.f_46443_) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11683_, this.m_5720_(), 0.3f, 1.0f, false);
                this.lastHit = this.f_19853_.m_46467_();
            }
        } else {
            super.m_7822_(p_31568_);
        }
    }

    public Iterable<ItemStack> m_6167_() {
        return this.handItems;
    }

    public Iterable<ItemStack> m_6168_() {
        return this.armorItems;
    }

    public ItemStack m_6844_(EquipmentSlot p_31612_) {
        switch (p_31612_.m_20743_()) {
            case HAND: {
                return (ItemStack)this.handItems.get(p_31612_.m_20749_());
            }
            case ARMOR: {
                return (ItemStack)this.armorItems.get(p_31612_.m_20749_());
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot p_31584_, ItemStack p_31585_) {
        this.m_181122_(p_31585_);
        switch (p_31584_.m_20743_()) {
            case HAND: {
                this.m_147218_(p_31585_);
                this.handItems.set(p_31584_.m_20749_(), (Object)p_31585_);
                break;
            }
            case ARMOR: {
                this.m_147218_(p_31585_);
                this.armorItems.set(p_31584_.m_20749_(), (Object)p_31585_);
            }
        }
    }

    public boolean m_6783_(double p_31574_) {
        double d0 = this.m_142469_().m_82309_() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return p_31574_ < (d0 *= 64.0) * d0;
    }

    private void showBreakingParticles() {
        if (this.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50705_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    private void causeDamage(DamageSource p_31649_, float p_31650_) {
        float f = this.m_21223_();
        if ((f -= p_31650_) <= 0.5f) {
            this.brokenByAnything(p_31649_);
            this.m_6074_();
        } else {
            this.m_21153_(f);
            this.m_146852_(GameEvent.f_157808_, p_31649_.m_7639_());
        }
    }

    private void brokenByPlayer(DamageSource p_31647_) {
        Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_142538_(), (ItemStack)this.m_142340_());
        this.brokenByAnything(p_31647_);
    }

    private void brokenByAnything(DamageSource p_31654_) {
        this.playBrokenSound();
        this.m_6668_(p_31654_);
    }

    private void playBrokenSound() {
        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11681_, this.m_5720_(), 1.0f, 1.0f);
    }

    protected float m_5632_(float p_31644_, float p_31645_) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    protected float m_6431_(Pose p_31614_, EntityDimensions p_31615_) {
        return p_31615_.f_20378_ * (this.m_6162_() ? 0.5f : 0.9f);
    }

    public double m_6049_() {
        return this.isMarker() ? 0.0 : (double)0.1f;
    }

    public void m_7023_(Vec3 p_31656_) {
        if (this.hasPhysics()) {
            super.m_7023_(p_31656_);
        }
    }

    public void m_5618_(float p_31670_) {
        this.f_20884_ = this.f_19859_ = p_31670_;
        this.f_20886_ = this.f_20885_ = p_31670_;
    }

    public void m_5616_(float p_31668_) {
        this.f_20884_ = this.f_19859_ = p_31668_;
        this.f_20886_ = this.f_20885_ = p_31668_;
    }

    protected void m_8034_() {
        this.m_6842_(this.invisible);
    }

    public void m_6842_(boolean p_31663_) {
        this.invisible = p_31663_;
        super.m_6842_(p_31663_);
    }

    public boolean m_6162_() {
        return this.isSmall();
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public boolean m_6128_() {
        return this.m_20145_();
    }

    public PushReaction m_7752_() {
        return this.isMarker() ? PushReaction.IGNORE : super.m_7752_();
    }

    private void setSmall(boolean p_31604_) {
        this.f_19804_.m_135381_(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS), 1, p_31604_));
    }

    public boolean isSmall() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS) & 1) != 0;
    }

    private void setMarker(boolean p_31682_) {
        this.f_19804_.m_135381_(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS), 16, p_31682_));
    }

    public boolean isMarker() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    private byte setBit(byte p_31570_, int p_31571_, boolean p_31572_) {
        p_31570_ = p_31572_ ? (byte)(p_31570_ | p_31571_) : (byte)(p_31570_ & ~p_31571_);
        return p_31570_;
    }

    public boolean m_6087_() {
        return super.m_6087_() && !this.isMarker();
    }

    public boolean m_7313_(Entity p_31687_) {
        return p_31687_ instanceof Player && !this.f_19853_.m_7966_((Player)p_31687_, this.m_142538_());
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    protected SoundEvent m_5896_(int p_31673_) {
        return SoundEvents.f_11682_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_31636_) {
        return SoundEvents.f_11683_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    public void m_8038_(ServerLevel p_31576_, LightningBolt p_31577_) {
    }

    public boolean m_5801_() {
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> p_31602_) {
        if (DATA_CLIENT_FLAGS.equals(p_31602_)) {
            this.m_6210_();
            this.f_19850_ = !this.isMarker();
        }
        super.m_7350_(p_31602_);
    }

    public boolean m_5789_() {
        return false;
    }

    public EntityDimensions m_6972_(Pose p_31587_) {
        return this.getDimensionsMarker(this.isMarker());
    }

    private EntityDimensions getDimensionsMarker(boolean p_31684_) {
        if (p_31684_) {
            return MARKER_DIMENSIONS;
        }
        return this.m_6162_() ? BABY_DIMENSIONS : this.m_6095_().m_20680_();
    }

    public Vec3 m_7371_(float p_31665_) {
        if (this.isMarker()) {
            AABB aabb = this.getDimensionsMarker(false).m_20393_(this.m_20182_());
            BlockPos blockpos = this.m_142538_();
            int i = Integer.MIN_VALUE;
            for (BlockPos blockpos1 : BlockPos.m_121940_((BlockPos)new BlockPos(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_), (BlockPos)new BlockPos(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_))) {
                int j = Math.max(this.f_19853_.m_45517_(LightLayer.BLOCK, blockpos1), this.f_19853_.m_45517_(LightLayer.SKY, blockpos1));
                if (j == 15) {
                    return Vec3.m_82512_((Vec3i)blockpos1);
                }
                if (j <= i) continue;
                i = j;
                blockpos = blockpos1.m_7949_();
            }
            return Vec3.m_82512_((Vec3i)blockpos);
        }
        return super.m_7371_(p_31665_);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ItemInit.SCARECROW);
    }

    public boolean m_142065_() {
        return !this.m_20145_() && !this.isMarker();
    }
}

