/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.glazedpots.register;

import de.z0rdak.glazedpots.block.GlazedFlowerPotBlock;
import de.z0rdak.glazedpots.register.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModBlocks {
    public static final List<Block> POTABLE_BLOCKS = new ArrayList<Block>();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"glazedpots");
    public static final Map<String, FlowerPotBlock> GLAZED_FLOWER_POT_BY_COLOR = new HashMap<String, FlowerPotBlock>(16);
    public static final Map<String, RegistryObject<FlowerPotBlock>> REGISTERED_GLAZED_FLOWER_POT_BY_COLOR = new HashMap<String, RegistryObject<FlowerPotBlock>>(16);
    public static final Map<String, Map<String, Block>> POTTED_POTS_BY_COLOR_AND_NAME = new HashMap<String, Map<String, Block>>();
    public static final Map<String, Map<String, RegistryObject<Block>>> REGISTERED_POTTED_POTS_BY_COLOR_AND_NAME = new HashMap<String, Map<String, RegistryObject<Block>>>();
    public static final Map<ResourceLocation, RegistryObject<Block>> REGISTERED_POTTED_POTS_BY_NAME = new HashMap<ResourceLocation, RegistryObject<Block>>();
    public static final FlowerPotBlock BLACK_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock BLUE_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock BROWN_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock CYAN_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock GRAY_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock GREEN_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock LIGHT_BLUE_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock LIGHT_GRAY_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock LIME_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock MAGENTA_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock ORANGE_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock PINK_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock PURPLE_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock RED_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock WHITE_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();
    public static final FlowerPotBlock YELLOW_GLAZED_FLOWER_POT = ModBlocks.newEmptyFlowerPot();

    public static FlowerPotBlock newEmptyFlowerPot() {
        return new FlowerPotBlock(null, () -> Blocks.field_150350_a, AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200946_b().func_226896_b_());
    }

    public static void register() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModItems.register();
    }

    static {
        GLAZED_FLOWER_POT_BY_COLOR.put(DyeColor.BLACK.func_176762_d(), BLACK_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put(DyeColor.BLUE.func_176762_d(), BLUE_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("brown", BROWN_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("cyan", CYAN_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("gray", GRAY_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("green", GREEN_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("light_blue", LIGHT_BLUE_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("light_gray", LIGHT_GRAY_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("lime", LIME_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("magenta", MAGENTA_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("orange", ORANGE_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("pink", PINK_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("purple", PURPLE_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("red", RED_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("white", WHITE_GLAZED_FLOWER_POT);
        GLAZED_FLOWER_POT_BY_COLOR.put("yellow", YELLOW_GLAZED_FLOWER_POT);
        POTABLE_BLOCKS.addAll(Arrays.asList(Blocks.field_196605_bc, Blocks.field_196606_bd, Blocks.field_196607_be, Blocks.field_196609_bf, Blocks.field_196610_bg, Blocks.field_196612_bh, Blocks.field_196613_bi, Blocks.field_196614_bj, Blocks.field_196615_bk, Blocks.field_196616_bl, Blocks.field_222387_by, Blocks.field_222383_bA, Blocks.field_222388_bz));
        POTABLE_BLOCKS.addAll(Arrays.asList(Blocks.field_196674_t, Blocks.field_196675_u, Blocks.field_196676_v, Blocks.field_196678_w, Blocks.field_196679_x, Blocks.field_196680_y));
        POTABLE_BLOCKS.addAll(Arrays.asList(Blocks.field_196554_aH, Blocks.field_222405_kQ, Blocks.field_150434_aF, Blocks.field_150337_Q, Blocks.field_150338_P, Blocks.field_196555_aI, Blocks.field_235382_mv_, Blocks.field_235373_mm_, Blocks.field_235375_mo_, Blocks.field_235343_mB_));
        for (DyeColor dyeColor : DyeColor.values()) {
            RegistryObject registeredBlock = BLOCKS.register(dyeColor.func_176762_d() + "_glazed_flower_pot", () -> GLAZED_FLOWER_POT_BY_COLOR.get(dyeColor.func_176762_d()));
            REGISTERED_GLAZED_FLOWER_POT_BY_COLOR.put(dyeColor.func_176762_d(), (RegistryObject<FlowerPotBlock>)registeredBlock);
        }
        GLAZED_FLOWER_POT_BY_COLOR.forEach((color, flowerPot) -> {
            HashMap pottedBlocksByName = new HashMap();
            HashMap registeredPottedBlocksByName = new HashMap();
            POTABLE_BLOCKS.forEach(block -> {
                GlazedFlowerPotBlock pot = new GlazedFlowerPotBlock(() -> GLAZED_FLOWER_POT_BY_COLOR.get(color), (Block)block);
                String glazedPotRegistryName = color + "_glazed_potted_" + block.getRegistryName().func_110623_a();
                RegistryObject registeredPottedPot = BLOCKS.register(glazedPotRegistryName, () -> pot);
                String potableBlockRegistryName = Objects.requireNonNull(block.getRegistryName()).toString();
                pottedBlocksByName.put(potableBlockRegistryName, pot);
                registeredPottedBlocksByName.put(potableBlockRegistryName, registeredPottedPot);
                REGISTERED_POTTED_POTS_BY_NAME.put(block.getRegistryName(), (RegistryObject<Block>)registeredPottedPot);
            });
            REGISTERED_POTTED_POTS_BY_COLOR_AND_NAME.put((String)color, registeredPottedBlocksByName);
            POTTED_POTS_BY_COLOR_AND_NAME.put((String)color, pottedBlocksByName);
        });
        ModItems.registerBlockItems();
    }
}

