/*
 * Decompiled with CFR 0.152.
 */
package coda.glumbis;

import coda.glumbis.init.GlumbisItems;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="glumbis")
public class Glumbis {
    public static final String MOD_ID = "glumbis";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String DATA_CAT = "CatData";

    public Glumbis() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        GlumbisItems.ITEMS.register(bus);
        forgeBus.addListener(this::onEntityInteract);
        forgeBus.addListener(this::onPlayerSleep);
        forgeBus.addListener(this::onEntityJoinWorld);
    }

    private void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        ItemStack stack = player.func_184586_b(hand);
        Item heldItem = stack.func_77973_b();
        if (target instanceof CatEntity && heldItem == GlumbisItems.SOCK.get()) {
            CompoundNBT tag = stack.func_196082_o();
            CompoundNBT targetTag = stack.serializeNBT();
            ItemStack glumbis = new ItemStack((IItemProvider)GlumbisItems.GLUMBIS.get());
            tag.func_218657_a(DATA_CAT, (INBT)targetTag);
            glumbis.func_77982_d(tag);
            target.func_70106_y();
            player.func_184611_a(hand, glumbis);
        }
    }

    private void onPlayerSleep(PlayerWakeUpEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_184582_a(EquipmentSlotType.FEET).func_77973_b().equals(GlumbisItems.SOGGY_SOCKS.get()) && player.func_110143_aJ() < player.func_110138_aP()) {
            player.func_70691_i(10.0f);
        }
    }

    private void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Predicate<LivingEntity> GLUMBIS_IN_PLAYERS_HOTBAR = player -> player instanceof PlayerEntity && (((PlayerEntity)player).field_71071_by.func_70301_a(0).func_77973_b().equals(GlumbisItems.GLUMBIS.get()) || ((PlayerEntity)player).field_71071_by.func_70301_a(1).func_77973_b().equals(GlumbisItems.GLUMBIS.get()) || ((PlayerEntity)player).field_71071_by.func_70301_a(2).func_77973_b().equals(GlumbisItems.GLUMBIS.get()) || ((PlayerEntity)player).field_71071_by.func_70301_a(3).func_77973_b().equals(GlumbisItems.GLUMBIS.get()) || ((PlayerEntity)player).field_71071_by.func_70301_a(4).func_77973_b().equals(GlumbisItems.GLUMBIS.get()) || ((PlayerEntity)player).field_71071_by.func_70301_a(5).func_77973_b().equals(GlumbisItems.GLUMBIS.get()) || ((PlayerEntity)player).field_71071_by.func_70301_a(6).func_77973_b().equals(GlumbisItems.GLUMBIS.get()) || ((PlayerEntity)player).field_71071_by.func_70301_a(7).func_77973_b().equals(GlumbisItems.GLUMBIS.get()) || ((PlayerEntity)player).field_71071_by.func_70301_a(8).func_77973_b().equals(GlumbisItems.GLUMBIS.get()));
        Entity entity = event.getEntity();
        if (entity instanceof CreeperEntity) {
            CreeperEntity creeper = (CreeperEntity)entity;
            creeper.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)creeper, PlayerEntity.class, 12.0f, 1.0, 1.2, GLUMBIS_IN_PLAYERS_HOTBAR));
        }
    }
}

