/*
 * Decompiled with CFR 0.152.
 */
package coda.glumbis.items;

import coda.glumbis.Glumbis;
import coda.glumbis.init.GlumbisItems;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GlumbisItem
extends Item {
    public static final String DATA_CREATURE = "CreatureData";

    public GlumbisItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        World level = player.field_70170_p;
        if (GlumbisItem.containsEntity(stack)) {
            return ActionResultType.PASS;
        }
        if (!target.func_184188_bt().isEmpty()) {
            target.func_184226_ay();
        }
        if (target instanceof CatEntity && !level.field_72995_K) {
            CompoundNBT tag = stack.func_196082_o();
            CompoundNBT targetTag = target.serializeNBT();
            targetTag.func_74778_a("OwnerName", player.func_200200_C_().getString());
            tag.func_218657_a(DATA_CREATURE, (INBT)targetTag);
            stack.func_77982_d(tag);
            target.func_70106_y();
            player.func_184611_a(hand, stack);
            level.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187620_cL, SoundCategory.AMBIENT, 1.0f, 1.0f);
        }
        return ActionResultType.func_233537_a_((boolean)true);
    }

    private static boolean containsEntity(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(DATA_CREATURE);
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        BlockRayTraceResult rt = GlumbisItem.func_219968_a((World)level, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        ItemStack stack = player.func_184586_b(hand);
        if (rt.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        BlockPos pos = rt.func_216350_a();
        if (!(level.func_180495_p(pos).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226248_a_((Object)stack);
        }
        return new ActionResult(GlumbisItem.releaseEntity(level, player, stack, pos, rt.func_216354_b()), (Object)stack);
    }

    private static ActionResultType releaseEntity(World level, PlayerEntity player, ItemStack stack, BlockPos pos, Direction direction) {
        LivingEntity entity;
        if (!GlumbisItem.containsEntity(stack)) {
            return ActionResultType.PASS;
        }
        CompoundNBT tag = stack.func_77978_p().func_74775_l(DATA_CREATURE);
        EntityType type = EntityType.func_220327_a((String)tag.func_74779_i("id")).orElse(null);
        if (type == null || (entity = (LivingEntity)type.func_200721_a(level)) == null) {
            Glumbis.LOGGER.error("Something went wrong releasing a cat!");
            return ActionResultType.FAIL;
        }
        EntitySize size = entity.func_213305_a(entity.func_213283_Z());
        if (!level.func_180495_p(pos).func_196952_d((IBlockReader)level, pos).func_197766_b()) {
            pos = pos.func_177967_a(direction, (int)(direction.func_176740_k().func_176722_c() ? size.field_220315_a : 1.0f));
        }
        entity.func_242281_f((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        AxisAlignedBB aabb = entity.func_174813_aQ();
        if (!level.func_226665_a__((Entity)entity, new AxisAlignedBB(aabb.field_72340_a, entity.func_226280_cw_() - 0.35, aabb.field_72339_c, aabb.field_72336_d, entity.func_226280_cw_() + 1.0, aabb.field_72334_f))) {
            return ActionResultType.FAIL;
        }
        if (!level.field_72995_K) {
            UUID id = entity.func_110124_au();
            entity.deserializeNBT(tag);
            entity.func_184221_a(id);
            entity.func_70012_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + direction.func_96559_d()) + 1.0, (double)pos.func_177952_p(), player.field_70126_B, 0.0f);
            if (stack.func_82837_s()) {
                entity.func_200203_b(stack.func_200301_q());
            }
            stack.func_196083_e(DATA_CREATURE);
            level.func_217376_c((Entity)entity);
            level.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_219602_O, SoundCategory.AMBIENT, 1.0f, 1.0f);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!(world instanceof ServerWorld)) {
            return ActionResultType.SUCCESS;
        }
        if (context.func_195996_i().func_77942_o()) {
            ItemStack itemstack = context.func_195996_i();
            BlockPos blockpos = context.func_195995_a();
            Direction direction = context.func_196000_l();
            BlockState blockstate = world.func_180495_p(blockpos);
            BlockPos blockpos1 = blockstate.func_196952_d((IBlockReader)world, blockpos).func_197766_b() ? blockpos : blockpos.func_177972_a(direction);
            ItemStack stack = context.func_195996_i();
            CompoundNBT tag = stack.func_77978_p().func_74775_l(DATA_CREATURE);
            EntityType type = EntityType.func_220327_a((String)tag.func_74779_i("id")).orElse(null);
            LivingEntity entity = (LivingEntity)type.func_200721_a(context.func_195991_k());
            if (entity == null) {
                return ActionResultType.FAIL;
            }
            UUID id = entity.func_110124_au();
            entity.deserializeNBT(tag);
            entity.func_184221_a(id);
            entity.func_70012_b((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p() + 0.5, context.func_195999_j().field_70126_B, 0.0f);
            if (stack.func_82837_s()) {
                entity.func_200203_b(stack.func_200301_q());
            }
            stack.func_196083_e(DATA_CREATURE);
            if (context.func_195991_k().func_217376_c((Entity)entity)) {
                itemstack.func_190918_g(1);
            }
            context.func_195991_k().func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187629_cO, SoundCategory.AMBIENT, 1.0f, 1.0f);
            context.func_195999_j().func_184611_a(context.func_221531_n(), new ItemStack((IItemProvider)GlumbisItems.SOCK.get()));
            return ActionResultType.CONSUME;
        }
        return super.func_195939_a(context);
    }
}

