/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.Gobber2;
import com.kwpugh.gobber2.items.rings.BaseRing;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class RingAttraction
extends BaseRing {
    static final String ATTRACTION_MODE = "Attraction Mode";
    static int configRange = Gobber2.CONFIG.GENERAL.ringAttractionRange;

    public RingAttraction(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            PlayerSpecialAbilities.doItemAttraction(world, player, stack);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 magnet = player.method_5998(hand);
        if (!world.field_9236 && !player.method_5715()) {
            this.toggleMode(magnet);
        }
        return new class_1271(class_1269.field_5812, (Object)magnet);
    }

    public static boolean isActive(class_1799 magnet) {
        return RingAttraction.getMagnetMode(magnet).getBoolean();
    }

    private void setMagnetMode(class_1799 magnet, MagnetMode mode) {
        RingAttraction.checkTag(magnet);
        magnet.method_7969().method_10556(ATTRACTION_MODE, mode.getBoolean());
    }

    private static MagnetMode getMagnetMode(class_1799 magnet) {
        if (!magnet.method_7960()) {
            RingAttraction.checkTag(magnet);
            return magnet.method_7969().method_10577(ATTRACTION_MODE) ? MagnetMode.ACTIVE : MagnetMode.INACTIVE;
        }
        return MagnetMode.INACTIVE;
    }

    private void toggleMode(class_1799 magnet) {
        MagnetMode currentMode = RingAttraction.getMagnetMode(magnet);
        if (currentMode.getBoolean()) {
            this.setMagnetMode(magnet, MagnetMode.INACTIVE);
            return;
        }
        this.setMagnetMode(magnet, MagnetMode.ACTIVE);
    }

    private static void checkTag(class_1799 magnet) {
        if (!magnet.method_7960()) {
            class_2487 nbt;
            if (!magnet.method_7985()) {
                magnet.method_7980(new class_2487());
            }
            if (!(nbt = magnet.method_7969()).method_10545(ATTRACTION_MODE)) {
                nbt.method_10556(ATTRACTION_MODE, false);
            }
        }
    }

    public boolean method_7886(class_1799 magnet) {
        return RingAttraction.isActive(magnet);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.gobber2.gobber2_ring_attraction.tip1").method_27692(class_124.field_1060));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.gobber2.right_click").method_27692(class_124.field_1054));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.gobber2.gobber2_ring_attraction.tip3", (Object[])new Object[]{configRange}).method_27692(class_124.field_1061));
    }

    public static enum MagnetMode {
        ACTIVE(true),
        INACTIVE(false);

        final boolean state;

        private MagnetMode(boolean state) {
            this.state = state;
        }

        public boolean getBoolean() {
            return this.state;
        }
    }
}

