/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.Gobber2;
import com.kwpugh.gobber2.items.rings.BaseRing;
import com.kwpugh.gobber2.util.MinerBlockTest;
import com.kwpugh.pugh_tools.util.MinerBlock;
import com.kwpugh.pugh_tools.util.MinerBlockManager;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;

public class RingMiner
extends BaseRing {
    static int minerCooldown = Gobber2.CONFIG.GENERAL.ringMinerCooldown;
    static int minerRange = Gobber2.CONFIG.GENERAL.ringMinerRange;
    static int minerVertical = Gobber2.CONFIG.GENERAL.ringMinerVerticalRange;
    static boolean centralizedBreaking = Gobber2.CONFIG.GENERAL.ringMinerCentralizedBreaking;
    static boolean minerDelayBreak = Gobber2.CONFIG.GENERAL.ringMinerCentralizedBreakingDelay;
    static boolean minerInstantBreak = Gobber2.CONFIG.GENERAL.ringMinerInstantBreak;
    static List<class_2338> posList = new ArrayList<class_2338>();
    class_2680 state;
    class_2248 block;
    class_2338 pos;
    static class_2338 breakPos;
    static boolean dropBlocks;
    boolean hasQuickUse;

    public RingMiner(class_1792.class_1793 settings) {
        super(settings);
    }

    public static void processList(class_1937 world, class_1657 player) {
        if (!world.field_9236 && !posList.isEmpty()) {
            dropBlocks = false;
            player.method_7353((class_2561)class_2561.method_43471((String)"Breaking blocks..."), true);
            if (player.method_6079().method_7909() == class_1802.field_8600) {
                dropBlocks = true;
            }
            breakPos = posList.get(0);
            world.method_22352(breakPos, dropBlocks);
            posList.remove(0);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 mainHand = player.method_5998(hand);
        class_1799 offHand = player.method_6079();
        if (!world.field_9236 && player.method_5715()) {
            dropBlocks = false;
            if (offHand.method_7909() == class_1802.field_8600) {
                dropBlocks = true;
            }
            for (int x = minerRange; x >= -minerRange; --x) {
                for (int y = minerVertical; y >= 0; --y) {
                    for (int z = minerRange; z >= -minerRange; --z) {
                        this.pos = player.method_24515().method_10069(x, y, z);
                        this.state = world.method_8320(this.pos);
                        this.block = this.state.method_26204();
                        if (!MinerBlockTest.canBreak(this.block, this.state)) continue;
                        if (minerInstantBreak) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"Breaking..."), true);
                            world.method_22352(this.pos, dropBlocks);
                            continue;
                        }
                        if (centralizedBreaking) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"Blocks selected, breaking scheduled"), true);
                            MinerBlock minerBlock = new MinerBlock(world, this.block, this.pos, player, dropBlocks, minerDelayBreak);
                            MinerBlockManager.addToList((MinerBlock)minerBlock);
                            continue;
                        }
                        player.method_7353((class_2561)class_2561.method_43471((String)"Breaking..."), true);
                        posList.add(this.pos);
                    }
                }
            }
            this.hasQuickUse = mainHand.method_7921().toString().contains("quickuse");
            if (!this.hasQuickUse) {
                player.method_7357().method_7906((class_1792)this, minerCooldown);
            }
        }
        return class_1271.method_22427((Object)mainHand);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.gobber2.gobber2_ring_miner.tip1").method_27692(class_124.field_1060));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.gobber2.gobber2_ring_miner.tip2").method_27692(class_124.field_1054));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.gobber2.gobber2_ring_miner.tip6", (Object[])new Object[]{minerRange * 2 + 1, minerVertical}).method_27692(class_124.field_1078));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.gobber2.gobber2_ring_miner.tip10").method_27692(class_124.field_1078));
    }
}

