/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.mixin;

import com.kwpugh.gobber2.Gobber2;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.items.rings.RingMiner;
import com.kwpugh.gobber2.items.rings.RingRepair;
import com.kwpugh.gobber2.util.EnableUtil;
import com.kwpugh.gobber2.util.PlayerEquipUtil;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixinTick
extends class_1309 {
    private static boolean allowEnder = Gobber2.CONFIG.GENERAL.allowWorkInEnderchest;
    private static int strengthLevel = Gobber2.CONFIG.GENERAL.ringStrengthLevel;
    private static int resistenceLevel = Gobber2.CONFIG.GENERAL.ringStrengthResistenceLevel;
    private static int hasteLevel = Gobber2.CONFIG.GENERAL.ringHasteLevel;
    private static int luckLevel = Gobber2.CONFIG.GENERAL.ringLuckLevel;
    private static int speedLevel = Gobber2.CONFIG.GENERAL.ringSwiftnessLevel;
    private static int jumpLevel = Gobber2.CONFIG.GENERAL.ringSwiftnessJump;
    private static int amount1 = Gobber2.CONFIG.GENERAL.medallionLesserHealingAmount;
    private static int amount2 = Gobber2.CONFIG.GENERAL.medallionHealingAmount;
    private static int amount3 = Gobber2.CONFIG.GENERAL.medallionGreaterHealingAmount;
    private static int shieldingHoriz = Gobber2.CONFIG.GENERAL.medallionShieldingHorizRange;
    private static int shieldingVert = Gobber2.CONFIG.GENERAL.medallionShieldingVertRange;
    private static int rangeSuffering = Gobber2.CONFIG.GENERAL.medallionSufferingRange;
    private static int damageSuffering = Gobber2.CONFIG.GENERAL.medallionSufferingDamage;

    protected PlayerEntityMixinTick(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"slowMovement"}, cancellable=true)
    public void gobberSlowMovement(class_2680 state, class_243 multiplier, CallbackInfo info) {
        class_1657 player = (class_1657)this;
        if (PlayerEquipUtil.hasItemInInventory(player, ItemInit.GOBBER2_RING_SWIFTNESS)) {
            info.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void gobberMinerTick(CallbackInfo ci) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            class_1657 player = (class_1657)this;
            RingMiner.processList(this.method_37908(), player);
            if (PlayerEquipUtil.hasItemInInventory(player, ItemInit.GOBBER2_RING_REPAIR)) {
                RingRepair.repairItems(this.method_37908(), player);
            }
            if (PlayerEquipUtil.hasItemInInventory(player, ItemInit.GOBBER2_RING_SUNSHINE) && Gobber2.CONFIG.GENERAL.ringSunshineAuto && server.method_8419()) {
                server.method_8401().method_157(false);
            }
            if (allowEnder) {
                class_1293 effect;
                class_1799 stack;
                class_1293 effect2;
                class_1293 effect3;
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_RING_STRENGTH)) {
                    effect3 = new class_1293(class_1294.field_5910, Gobber2.CONFIG.GENERAL.effectDuration, strengthLevel, false, false);
                    effect2 = new class_1293(class_1294.field_5907, Gobber2.CONFIG.GENERAL.effectDuration, resistenceLevel, false, false);
                    player.method_6092(effect3);
                    player.method_6092(effect2);
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_RING_REPAIR)) {
                    RingRepair.repairItems(this.method_37908(), player);
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_RING_ASCENT)) {
                    player.field_6017 = 0.0f;
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_RING_ATTRACTION)) {
                    stack = PlayerEquipUtil.getItemStackInEnderchest(player, ItemInit.GOBBER2_RING_ATTRACTION);
                    PlayerSpecialAbilities.doItemAttraction(this.method_37908(), player, stack);
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_RING_HASTE) && EnableUtil.isEnabled(stack = PlayerEquipUtil.getItemStackInEnderchest(player, ItemInit.GOBBER2_RING_HASTE))) {
                    effect = new class_1293(class_1294.field_5917, Gobber2.CONFIG.GENERAL.effectDuration, hasteLevel, false, false);
                    player.method_6092(effect);
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_RING_LUCK) && EnableUtil.isEnabled(stack = PlayerEquipUtil.getItemStackInEnderchest(player, ItemInit.GOBBER2_RING_LUCK))) {
                    effect = new class_1293(class_1294.field_5926, Gobber2.CONFIG.GENERAL.effectDuration, luckLevel, false, false);
                    player.method_6092(effect);
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_RING_SWIFTNESS) && EnableUtil.isEnabled(stack = PlayerEquipUtil.getItemStackInEnderchest(player, ItemInit.GOBBER2_RING_SWIFTNESS))) {
                    class_1293 speed = new class_1293(class_1294.field_5904, Gobber2.CONFIG.GENERAL.effectDuration, speedLevel, false, false);
                    class_1293 jump = new class_1293(class_1294.field_5913, Gobber2.CONFIG.GENERAL.effectDuration, jumpLevel, false, false);
                    player.method_6092(speed);
                    player.method_6092(jump);
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_RING_VISION) && EnableUtil.isEnabled(stack = PlayerEquipUtil.getItemStackInEnderchest(player, ItemInit.GOBBER2_RING_VISION))) {
                    effect = new class_1293(class_1294.field_5925, Gobber2.CONFIG.GENERAL.effectDurationNightVision, 0, false, false);
                    player.method_6092(effect);
                    if (player.method_6059(class_1294.field_38092)) {
                        player.method_6016(class_1294.field_38092);
                    }
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_MEDALLION_HERO)) {
                    effect3 = new class_1293(class_1294.field_18980, 8, 0, false, false);
                    player.method_6092(effect3);
                    if (player.method_6059(class_1294.field_16595)) {
                        // empty if block
                    }
                    player.method_6016(class_1294.field_16595);
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_MEDALLION_SEA) && player.method_5869()) {
                    effect3 = new class_1293(class_1294.field_5927, 8, 0, false, false);
                    effect2 = new class_1293(class_1294.field_5900, 8, 0, false, false);
                    player.method_6092(effect3);
                    player.method_6092(effect2);
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_MEDALLION_HEALING)) {
                    PlayerSpecialAbilities.giveHealing(player, amount1);
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_MEDALLION_HEALING2)) {
                    PlayerSpecialAbilities.giveHealing(player, amount2);
                    PlayerSpecialAbilities.giveSaturationEffect(player);
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_MEDALLION_HEALING3)) {
                    PlayerSpecialAbilities.giveHealing(player, amount3);
                    PlayerSpecialAbilities.giveSaturationEffect(player);
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_MEDALLION_SHIELDING)) {
                    PlayerSpecialAbilities.giveProjectileShield(this.method_37908(), player, shieldingVert, shieldingHoriz);
                }
                if (PlayerEquipUtil.hasItemInEnderchest(player, ItemInit.GOBBER2_MEDALLION_SUFFERING)) {
                    class_2338 pos = player.method_24515();
                    PlayerSpecialAbilities.inflictSuffering(this.method_37908(), pos, rangeSuffering, damageSuffering);
                }
            }
        }
    }
}

