/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.util.EnableUtil;
import com.kwpugh.gobber2.util.MagnetRangeUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomRingAttraction
extends Item {
    int ringAttractionBlocking = (Integer)GobberConfigBuilder.RING_ATTRACTION_BLOCK_DISTANCE.get();
    boolean ringAttractionMode = (Boolean)GobberConfigBuilder.RING_ATTRACTION_MODE.get();
    static int range;

    public ItemCustomRingAttraction(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof Player && !world.f_46443_ && EnableUtil.isEnabled(stack)) {
            Player player = (Player)entity;
            boolean init = MagnetRangeUtil.getCurrentlySet(stack);
            range = !init ? 8 : MagnetRangeUtil.getCurrentRange(stack);
            double x = player.m_20185_();
            double y = player.m_20186_();
            double z = player.m_20189_();
            BlockPos playerPos = new BlockPos(player.m_20182_());
            for (Object targetPos : BlockPos.m_121940_((BlockPos)playerPos.m_142082_(-range, -this.ringAttractionBlocking, -range), (BlockPos)playerPos.m_142082_(range, this.ringAttractionBlocking, range))) {
                BlockState blockstate = world.m_8055_((BlockPos)targetPos);
                if (blockstate.m_60734_() != Blocks.f_50353_) continue;
                return;
            }
            List items = entity.f_19853_.m_45976_(ItemEntity.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
            for (ItemEntity e : items) {
                if (player.m_6144_() || e.getPersistentData().m_128471_("PreventRemoteMovement")) continue;
                if (this.ringAttractionMode) {
                    e.m_6123_(player);
                    continue;
                }
                double factor = 0.035;
                e.m_5997_((x - e.m_20185_()) * factor, (y - e.m_20186_() + 1.25) * factor, (z - e.m_20189_()) * factor);
            }
            List xp = entity.f_19853_.m_45976_(ExperienceOrb.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
            for (ExperienceOrb orb : xp) {
                if (player.m_6144_()) continue;
                if (this.ringAttractionMode) {
                    orb.m_6123_(player);
                    continue;
                }
                double factor = 0.035;
                orb.m_5997_((x - orb.m_20185_()) * factor, (y - orb.m_20186_() + 1.25) * factor, (z - orb.m_20189_()) * factor);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && !player.m_6144_()) {
            EnableUtil.changeEnabled(player, hand);
            player.m_5661_((Component)new TranslatableComponent("item.gobber2.gobber2_ring_attraction.line2", new Object[]{EnableUtil.isEnabled(stack)}).m_130940_(ChatFormatting.GREEN), true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
        }
        if (!world.f_46443_ && player.m_6144_()) {
            switch (range) {
                case 8: {
                    range = 10;
                    MagnetRangeUtil.setCurrentRange(stack, range);
                    player.m_5661_((Component)new TranslatableComponent("item.gobber2.gobber2_ring_attraction.line5", new Object[]{MagnetRangeUtil.getCurrentRange(stack)}).m_130940_(ChatFormatting.GREEN), true);
                    break;
                }
                case 10: {
                    range = 12;
                    MagnetRangeUtil.setCurrentRange(stack, range);
                    player.m_5661_((Component)new TranslatableComponent("item.gobber2.gobber2_ring_attraction.line5", new Object[]{MagnetRangeUtil.getCurrentRange(stack)}).m_130940_(ChatFormatting.GREEN), true);
                    break;
                }
                case 12: {
                    range = 14;
                    MagnetRangeUtil.setCurrentRange(stack, range);
                    player.m_5661_((Component)new TranslatableComponent("item.gobber2.gobber2_ring_attraction.line5", new Object[]{MagnetRangeUtil.getCurrentRange(stack)}).m_130940_(ChatFormatting.GREEN), true);
                    break;
                }
                case 14: {
                    range = 4;
                    MagnetRangeUtil.setCurrentRange(stack, range);
                    player.m_5661_((Component)new TranslatableComponent("item.gobber2.gobber2_ring_attraction.line5", new Object[]{MagnetRangeUtil.getCurrentRange(stack)}).m_130940_(ChatFormatting.GREEN), true);
                    break;
                }
                case 4: {
                    range = 8;
                    MagnetRangeUtil.setCurrentRange(stack, range);
                    player.m_5661_((Component)new TranslatableComponent("item.gobber2.gobber2_ring_attraction.line5", new Object[]{MagnetRangeUtil.getCurrentRange(stack)}).m_130940_(ChatFormatting.GREEN), true);
                    break;
                }
            }
        }
        return super.m_7203_(world, player, hand);
    }

    public boolean m_5812_(ItemStack stack) {
        return EnableUtil.isEnabled(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_attraction.line1").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_attraction.line2", new Object[]{EnableUtil.isEnabled(stack)}).m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_attraction.line3").m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_attraction.line4").m_130940_(ChatFormatting.RED));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_attraction.line6").m_130940_(ChatFormatting.BLUE));
        if (EnableUtil.isEnabled(stack)) {
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_attraction.line5", new Object[]{MagnetRangeUtil.getCurrentRange(stack)}).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
    }
}

