/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomRingExplorer
extends Item {
    int ringExplorerCooldown = (Integer)GobberConfigBuilder.RING_EXPLORER_COOLDOWN.get();
    int min = (Integer)GobberConfigBuilder.RING_EXPLORER_MIN_RANGE.get();
    int max = (Integer)GobberConfigBuilder.RING_EXPLORER_MAX_RANGE.get();

    public ItemCustomRingExplorer(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_36335_().m_41524_((Item)this, this.ringExplorerCooldown);
        if (!world.m_46472_().equals((Object)Level.f_46428_)) {
            player.m_5661_((Component)new TranslatableComponent("item.gobber2.gobber2_ring_above.line5"), true);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (!world.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)world;
            BlockPos worldSpawn = serverWorld.m_8900_();
            Random rand = new Random();
            int x = Math.round(worldSpawn.m_123341_()) + rand.nextInt(this.max + this.min) - this.min;
            int y = 255;
            int z = Math.round(worldSpawn.m_123343_()) + rand.nextInt(this.max + this.min) - this.min;
            LevelChunk chunk = world.m_6325_(x >> 4, z >> 4);
            Biome biome = world.m_46857_(new BlockPos(x, y, z));
            if (biome.m_47567_().m_47645_().equals("ocean") || biome.m_47567_().m_47645_().equals("river") || biome.m_47567_().m_47645_().equals("beach")) {
                if (world.f_46443_) {
                    player.m_36335_().m_41527_((Item)this);
                }
                return this.m_7203_(world, player, hand);
            }
            while (y > 0) {
                BlockPos headPos;
                BlockPos legPos;
                BlockPos groundPos;
                if (chunk.m_8055_(groundPos = new BlockPos(x, --y - 2, z)).m_60767_().equals(Material.f_76296_) || chunk.m_8055_(groundPos).m_60734_().equals(Blocks.f_50752_) || chunk.m_8055_(groundPos).m_60734_().equals(Blocks.f_49990_) || y - 2 == 1 || !chunk.m_8055_(legPos = new BlockPos(x, y - 1, z)).m_60767_().equals(Material.f_76296_) || !chunk.m_8055_(headPos = new BlockPos(x, y, z)).m_60767_().equals(Material.f_76296_)) continue;
                player.m_8127_();
                ((ServerPlayer)player).f_8906_.m_9774_((double)x, (double)y, (double)z, player.f_19859_, player.f_19860_);
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            player.m_5661_((Component)new TranslatableComponent("Sorry, no spot found, try again after cooldown"), true);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_explorer.line1").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_explorer.line2", new Object[]{this.min, this.max}).m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_explorer.line3").m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring.cooldown", new Object[]{this.ringExplorerCooldown}).m_130940_(ChatFormatting.LIGHT_PURPLE));
    }
}

