/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomRingTeleport
extends Item {
    boolean limitedUse = (Boolean)GobberConfigBuilder.RING_TELEPORT_LIMITED_USE.get();

    public ItemCustomRingTeleport(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Direction direction = context.m_43719_();
        ItemStack stackRing = context.m_43723_().m_21205_();
        if (ItemCustomRingTeleport.getPosition(stackRing) == null && player.m_6047_()) {
            ItemCustomRingTeleport.setPosition(stackRing, world, pos.m_142300_(direction), player);
            player.m_6352_((Component)new TranslatableComponent("item.gobber2.ring_teleport.line1").m_130940_(ChatFormatting.YELLOW), null);
            return InteractionResult.SUCCESS;
        }
        if (ItemCustomRingTeleport.getPosition(stackRing) != null) {
            player.m_6352_((Component)new TranslatableComponent("item.gobber2.ring_teleport.line2").m_130940_(ChatFormatting.YELLOW), null);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (ItemCustomRingTeleport.getPosition(stack) != null && !player.m_6047_()) {
            this.teleport(player, world, stack);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (ItemCustomRingTeleport.getPosition(stack) != null && player.m_6047_()) {
            ItemCustomRingTeleport.setPosition(stack, world, null, player);
            player.m_6352_((Component)new TranslatableComponent("item.gobber2.ring_teleport.line3").m_130940_(ChatFormatting.YELLOW), null);
        }
        if (this.limitedUse) {
            stack.m_41721_(this.getDamage(stack) + 1);
            if (stack.m_41773_() >= stack.m_41776_()) {
                stack.m_41774_(1);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    public static BlockPos getPosition(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag tags = stack.m_41783_();
        if (tags.m_128441_("pos")) {
            return NbtUtils.m_129239_((CompoundTag)((CompoundTag)tags.m_128423_("pos")));
        }
        return null;
    }

    public static String getDimension(ItemStack stack) {
        CompoundTag tags = stack.m_41783_();
        if (stack.m_41782_() && tags.m_128441_("dim")) {
            return stack.m_41783_().m_128461_("dim");
        }
        return null;
    }

    public static void setPosition(ItemStack stack, Level world, BlockPos pos, Player player) {
        if (world.f_46443_) {
            return;
        }
        CompoundTag tags = !stack.m_41782_() ? new CompoundTag() : stack.m_41783_();
        if (pos == null) {
            tags.m_128473_("pos");
            tags.m_128473_("dim");
        } else {
            ResourceKey resourceKey = world.m_46472_();
            ResourceLocation name = resourceKey.m_135782_();
            tags.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            tags.m_128359_("dim", name.toString());
        }
        stack.m_41751_(tags);
    }

    public void teleport(Player player, Level world, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        BlockPos pos = ItemCustomRingTeleport.getPosition(stack);
        String dim = ItemCustomRingTeleport.getDimension(stack);
        ResourceKey currentDim = world.m_46472_();
        ServerLevel serverWorld = ((ServerLevel)world).m_142572_().m_129880_(currentDim);
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ResourceKey storedKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dim));
        ServerLevel storedWorld = ((ServerLevel)world).m_142572_().m_129880_(storedKey);
        if (serverWorld == storedWorld) {
            serverPlayer.m_6021_((double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f));
        } else {
            serverPlayer.m_8999_(storedWorld, (double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f), serverPlayer.m_8962_(), serverPlayer.m_8962_());
        }
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent("item.gobber2.ring_teleport.line9").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.ring_teleport.line11").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.ring_teleport.line12").m_130940_(ChatFormatting.RED));
        if (ItemCustomRingTeleport.getPosition(stack) != null) {
            BlockPos pos = ItemCustomRingTeleport.getPosition(stack);
            tooltip.add((Component)new TranslatableComponent("item.gobber2.ring_teleport.line13").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)new TranslatableComponent("item.gobber2.ring_teleport.line14", new Object[]{ItemCustomRingTeleport.getDimension(stack), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.LIGHT_PURPLE));
            tooltip.add((Component)new TranslatableComponent("item.gobber2.ring_teleport.line18", new Object[]{this.limitedUse}).m_130940_(ChatFormatting.YELLOW));
        }
    }
}

