/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.tools.paxel;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.init.TagInit;
import com.kwpugh.gobber2.items.toolbaseclasses.PaxelBase;
import com.kwpugh.gobber2.util.EnableUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ItemCustomPaxelStars
extends PaxelBase {
    public ItemCustomPaxelStars(float attackDamageIn, float attackSpeedIn, Tier tier, Tag<Block> mineabl, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, tier, TagInit.PAXEL_MINEABLE, builder);
    }

    @Override
    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_60620_((Tag)BlockTags.f_144280_)) {
            return this.f_40980_;
        }
        if (state.m_60620_((Tag)BlockTags.f_144282_)) {
            return this.f_40980_;
        }
        if (state.m_60620_((Tag)BlockTags.f_144283_)) {
            return this.f_40980_;
        }
        return super.m_8102_(stack, state);
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        boolean actionTest = false;
        if (ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(toolAction)) {
            actionTest = true;
        }
        return actionTest;
    }

    @Override
    public InteractionResult m_6225_(UseOnContext iuc) {
        BlockPos torchPos;
        BlockPos pos = iuc.m_8083_();
        Level world = iuc.m_43725_();
        BlockPos blockpos = iuc.m_8083_();
        Player player = iuc.m_43723_();
        ItemStack stack = player.m_21205_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (!EnableUtil.isEnabled(stack)) {
            Level level = iuc.m_43725_();
            Optional<BlockState> optional = Optional.ofNullable(blockstate.getToolModifiedState(level, blockpos, player, iuc.m_43722_(), ToolActions.AXE_STRIP));
            Optional<BlockState> optional1 = Optional.ofNullable(blockstate.getToolModifiedState(level, blockpos, player, iuc.m_43722_(), ToolActions.AXE_SCRAPE));
            Optional<BlockState> optional2 = Optional.ofNullable(blockstate.getToolModifiedState(level, blockpos, player, iuc.m_43722_(), ToolActions.AXE_WAX_OFF));
            ItemStack itemstack = iuc.m_43722_();
            Optional<Object> optional3 = Optional.empty();
            if (optional.isPresent()) {
                level.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                optional3 = optional;
            } else if (optional1.isPresent()) {
                level.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5898_(player, 3005, blockpos, 0);
                optional3 = optional1;
            } else if (optional2.isPresent()) {
                level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5898_(player, 3004, blockpos, 0);
                optional3 = optional2;
            }
            if (optional3.isPresent()) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, blockpos, itemstack);
                }
                level.m_7731_(blockpos, (BlockState)optional3.get(), 11);
                if (player != null) {
                    itemstack.m_41622_(1, (LivingEntity)player, p_150686_ -> p_150686_.m_21190_(iuc.m_43724_()));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (iuc.m_43719_() == Direction.DOWN) {
                return InteractionResult.PASS;
            }
            BlockState blockstate1 = blockstate.getToolModifiedState(level, blockpos, player, iuc.m_43722_(), ToolActions.SHOVEL_FLATTEN);
            BlockState blockstate2 = null;
            if (blockstate1 != null && level.m_46859_(blockpos.m_7494_())) {
                level.m_5594_(player, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
                blockstate2 = blockstate1;
            } else if (blockstate.m_60734_() instanceof CampfireBlock && ((Boolean)blockstate.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                if (!level.m_5776_()) {
                    level.m_5898_((Player)null, 1009, blockpos, 0);
                }
                CampfireBlock.m_152749_((Entity)iuc.m_43723_(), (LevelAccessor)level, (BlockPos)blockpos, (BlockState)blockstate);
                blockstate2 = (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
            }
            if (blockstate2 != null) {
                if (!level.f_46443_) {
                    level.m_7731_(blockpos, blockstate2, 11);
                    if (player != null) {
                        iuc.m_43722_().m_41622_(1, (LivingEntity)player, p_43122_ -> p_43122_.m_21190_(iuc.m_43724_()));
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            stack.m_41721_(0);
            return InteractionResult.SUCCESS;
        }
        if (iuc.m_43725_().m_8055_(pos).m_60734_() == Blocks.f_50081_ || iuc.m_43725_().m_8055_(pos).m_60734_() == Blocks.f_50082_) {
            return InteractionResult.FAIL;
        }
        Boolean isWallTorch = false;
        switch (iuc.m_43719_()) {
            case DOWN: {
                return InteractionResult.FAIL;
            }
            case UP: {
                torchPos = new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                break;
            }
            case NORTH: {
                torchPos = new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1);
                isWallTorch = true;
                break;
            }
            case SOUTH: {
                torchPos = new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1);
                isWallTorch = true;
                break;
            }
            case WEST: {
                torchPos = new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_());
                isWallTorch = true;
                break;
            }
            case EAST: {
                torchPos = new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
                isWallTorch = true;
                break;
            }
            default: {
                return InteractionResult.FAIL;
            }
        }
        if (iuc.m_43725_().m_8055_(torchPos).m_60795_() || iuc.m_43725_().m_8055_(torchPos).m_60819_().m_76170_()) {
            if (blockstate.m_60796_((BlockGetter)world, pos)) {
                if (isWallTorch.booleanValue()) {
                    iuc.m_43725_().m_46597_(torchPos, (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)iuc.m_43719_()));
                    iuc.m_43725_().m_5594_(null, iuc.m_43723_().m_142538_(), SoundEvents.f_12635_, SoundSource.NEUTRAL, 8.0f, (float)((double)0.7f + Math.random() * 0.3));
                } else {
                    iuc.m_43725_().m_46597_(torchPos, Blocks.f_50081_.m_49966_());
                    iuc.m_43725_().m_5594_(null, iuc.m_43723_().m_142538_(), SoundEvents.f_12635_, SoundSource.NEUTRAL, 8.0f, (float)((double)0.7f + Math.random() * 0.3));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && player.m_6144_()) {
            EnableUtil.changeEnabled(player, hand);
            player.m_5661_((Component)new TranslatableComponent("item.gobber2.gobber2_paxel_stars.line4", new Object[]{EnableUtil.isEnabled(stack)}).m_130940_(ChatFormatting.RED), true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
        }
        return super.m_7203_(world, player, hand);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41721_(0);
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.f_46443_ && (double)state.m_60800_((BlockGetter)worldIn, pos) != 0.0) {
            stack.m_41721_(0);
        }
        return true;
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        if (((Boolean)GobberConfigBuilder.END_GOBBER_TOOLS_UNBREAKABLE.get()).booleanValue()) {
            stack.m_41784_().m_128379_("Unbreakable", true);
        }
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_paxel_stars.line2").m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_paxel_stars.line3").m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_paxel_stars.line4", new Object[]{EnableUtil.isEnabled(stack)}).m_130940_(ChatFormatting.RED));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_paxel_stars.line5").m_130940_(ChatFormatting.LIGHT_PURPLE));
    }
}

