/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.world;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.world.GobberConfiguredFeature;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GobberPlacedFeature {
    public static PlacedFeature ORE_LUCKY_BLOCK_OVERWORLD;
    public static PlacedFeature ORE_LUCKY_BLOCK_OVERWORLD_DEEPSLATE;
    public static PlacedFeature ORE_LUCKY_BLOCK_NETHER;
    public static PlacedFeature ORE_GOBBER_OVERWORLD;
    public static PlacedFeature ORE_GOBBER_OVERWORLD_DEEPSLATE;
    public static PlacedFeature ORE_GOBBER_NETHER;
    public static PlacedFeature ORE_GOBBER_THEEND;

    public static void registerPlacedFeatures() {
        ORE_LUCKY_BLOCK_OVERWORLD = GobberConfiguredFeature.GOBBER2_LUCKY_BLOCK.m_190821_(GobberPlacedFeature.commonOrePlacement((Integer)GobberConfigBuilder.GOBBER2_LUCKY_BLOCK_CHANCE.get(), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_LUCKY_BLOCK_MIN_HEIGHT.get())), (VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_LUCKY_BLOCK_MAX_HEIGHT.get())))));
        ORE_LUCKY_BLOCK_OVERWORLD_DEEPSLATE = GobberConfiguredFeature.GOBBER2_LUCKY_BLOCK_DEEPSLATE.m_190821_(GobberPlacedFeature.commonOrePlacement((Integer)GobberConfigBuilder.GOBBER2_LUCKY_BLOCK_DEEPSLATE_CHANCE.get(), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_LUCKY_BLOCK_DEEPSLATE_MIN_HEIGHT.get())), (VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_LUCKY_BLOCK_DEEPSLATE_MAX_HEIGHT.get())))));
        ORE_LUCKY_BLOCK_NETHER = GobberConfiguredFeature.GOBBER2_LUCKY_BLOCK_NETHER.m_190821_(GobberPlacedFeature.commonOrePlacement((Integer)GobberConfigBuilder.GOBBER2_LUCKY_BLOCK_NETHER_CHANCE.get(), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_LUCKY_BLOCK_NETHER_MIN_HEIGHT.get())), (VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_LUCKY_BLOCK_NETHER_MAX_HEIGHT.get())))));
        ORE_GOBBER_OVERWORLD = GobberConfiguredFeature.GOBBER2_ORE.m_190821_(GobberPlacedFeature.commonOrePlacement((Integer)GobberConfigBuilder.GOBBER2_ORE_CHANCE.get(), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_ORE_MIN_HEIGHT.get())), (VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_ORE_MAX_HEIGHT.get())))));
        ORE_GOBBER_OVERWORLD_DEEPSLATE = GobberConfiguredFeature.GOBBER2_ORE_DEEPSLATE.m_190821_(GobberPlacedFeature.commonOrePlacement((Integer)GobberConfigBuilder.GOBBER2_ORE_DEEPSLATE_CHANCE.get(), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_ORE_DEEPSLATE_MIN_HEIGHT.get())), (VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_ORE_DEEPSLATE_MAX_HEIGHT.get())))));
        ORE_GOBBER_NETHER = GobberConfiguredFeature.GOBBER2_ORE_NETHER.m_190821_(GobberPlacedFeature.commonOrePlacement((Integer)GobberConfigBuilder.GOBBER2_ORE_NETHER_CHANCE.get(), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_ORE_NETHER_MIN_HEIGHT.get())), (VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_ORE_NETHER_MAX_HEIGHT.get())))));
        ORE_GOBBER_THEEND = GobberConfiguredFeature.GOBBER2_ORE_END.m_190821_(GobberPlacedFeature.commonOrePlacement((Integer)GobberConfigBuilder.GOBBER2_ORE_END_CHANCE.get(), (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_ORE_END_MIN_HEIGHT.get())), (VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)GobberConfigBuilder.GOBBER2_ORE_END_MAX_HEIGHT.get())))));
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("gobber2", "gobber2_lucky_block"), (Object)ORE_LUCKY_BLOCK_OVERWORLD);
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("gobber2", "gobber2_lucky_block_deepslate"), (Object)ORE_LUCKY_BLOCK_OVERWORLD_DEEPSLATE);
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("gobber2", "gobber2_lucky_block_nether"), (Object)ORE_LUCKY_BLOCK_NETHER);
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("gobber2", "gobber2_ore"), (Object)ORE_GOBBER_OVERWORLD);
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("gobber2", "gobber2_ore_deepslate"), (Object)ORE_GOBBER_OVERWORLD_DEEPSLATE);
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("gobber2", "gobber2_ore_nether"), (Object)ORE_GOBBER_NETHER);
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("gobber2", "gobber2_ore_end"), (Object)ORE_GOBBER_THEEND);
    }

    @SubscribeEvent
    public static void registerBiomeModification(BiomeLoadingEvent event) {
        if (((Boolean)GobberConfigBuilder.GOBBER2_LUCKY_BLOCK_GENERATION.get()).booleanValue()) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(() -> ORE_LUCKY_BLOCK_OVERWORLD);
        }
        if (((Boolean)GobberConfigBuilder.GOBBER2_LUCKY_BLOCK_DEEPSLATE_GENERATION.get()).booleanValue()) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(() -> ORE_LUCKY_BLOCK_OVERWORLD_DEEPSLATE);
        }
        if (((Boolean)GobberConfigBuilder.GOBBER2_LUCKY_BLOCK_NETHER_GENERATION.get()).booleanValue() && event.getCategory() == Biome.BiomeCategory.NETHER) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(() -> ORE_LUCKY_BLOCK_NETHER);
        }
        if (((Boolean)GobberConfigBuilder.GOBBER2_ORE_GENERATION.get()).booleanValue()) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(() -> ORE_GOBBER_OVERWORLD);
        }
        if (((Boolean)GobberConfigBuilder.GOBBER2_ORE_DEEPSLATE_GENERATION.get()).booleanValue()) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(() -> ORE_GOBBER_OVERWORLD_DEEPSLATE);
        }
        if (((Boolean)GobberConfigBuilder.GOBBER2_ORE_NETHER_GENERATION.get()).booleanValue() && event.getCategory() == Biome.BiomeCategory.NETHER) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(() -> ORE_GOBBER_NETHER);
        }
        if (((Boolean)GobberConfigBuilder.GOBBER2_ORE_END_GENERATION.get()).booleanValue() && event.getCategory() == Biome.BiomeCategory.THEEND) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(() -> ORE_GOBBER_THEEND);
        }
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(int p_195344_, PlacementModifier p_195345_) {
        return GobberPlacedFeature.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)p_195344_), p_195345_);
    }

    private static List<PlacementModifier> rareOrePlacement(int p_195350_, PlacementModifier p_195351_) {
        return GobberPlacedFeature.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)p_195350_), p_195351_);
    }
}

