/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomArmorNether
extends ArmorItem {
    boolean enablePerks = (Boolean)GobberConfigBuilder.ENABLE_GOBBER_NETHER_ARMOR_HEALTH_PERKS.get();
    int hunger = (Integer)GobberConfigBuilder.GOBBER_NETHER_ARMOR_HUNGER.get();
    double saturation = (Double)GobberConfigBuilder.GOBBER_NETHER_ARMOR_SATURATION.get();

    public ItemCustomArmorNether(ArmorMaterial materialIn, EquipmentSlot slots, Item.Properties builder) {
        super(materialIn, slots, builder);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!this.enablePerks) {
            return;
        }
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = player.m_6844_(EquipmentSlot.FEET);
        if (head.m_41720_() == ItemInit.GOBBER2_HELMET_NETHER.get() && chest.m_41720_() == ItemInit.GOBBER2_CHESTPLATE_NETHER.get() && legs.m_41720_() == ItemInit.GOBBER2_LEGGINGS_NETHER.get() && feet.m_41720_() == ItemInit.GOBBER2_BOOTS_NETHER.get()) {
            if (player.m_21124_(MobEffects.f_19614_) != null) {
                player.m_21195_(MobEffects.f_19614_);
            }
            if (player.m_21124_(MobEffects.f_19615_) != null) {
                player.m_21195_(MobEffects.f_19615_);
            }
        }
        if (head.m_41720_() == ItemInit.GOBBER2_HELMET_NETHER.get()) {
            PlayerSpecialAbilities.giveYellowHearts(world, (LivingEntity)player, stack, 4, 0.33f);
            PlayerSpecialAbilities.giveRegenEffect(world, player, stack, this.hunger, (float)this.saturation);
        }
        if (chest.m_41720_() == ItemInit.GOBBER2_CHESTPLATE_NETHER.get()) {
            // empty if block
        }
        if (legs.m_41720_() == ItemInit.GOBBER2_LEGGINGS_NETHER.get()) {
            // empty if block
        }
        if (feet.m_41720_() == ItemInit.GOBBER2_BOOTS_NETHER.get()) {
            // empty if block
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_41720_() == ItemInit.GOBBER2_INGOT_NETHER.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.enablePerks) {
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_armor_nether.line2").m_130940_(ChatFormatting.LIGHT_PURPLE));
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_armor_nether.line3").m_130940_(ChatFormatting.LIGHT_PURPLE));
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_armor_nether.line4").m_130940_(ChatFormatting.LIGHT_PURPLE));
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_armor_nether.line5").m_130940_(ChatFormatting.LIGHT_PURPLE));
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_armor_nether.line6").m_130940_(ChatFormatting.GOLD));
        }
    }
}

