/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.util.RayTraceUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomRingBlink
extends Item {
    int blinkCooldown = (Integer)GobberConfigBuilder.RING_BLINK_COOLDOWN.get();

    public ItemCustomRingBlink(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        int side;
        HitResult pos;
        ItemStack stack = player.m_21120_(hand);
        player.m_36335_().m_41524_((Item)this, this.blinkCooldown);
        if (!world.f_46443_ && (pos = RayTraceUtil.getNearestPositionWithAir(world, player, 100)) != null && (pos.m_6662_() == HitResult.Type.BLOCK || player.f_19860_ >= -5.0f) && (side = pos.m_6662_().ordinal()) != -1) {
            double x = pos.m_82450_().f_82479_ - (side == 4 ? 0.5 : 0.0) + (side == 5 ? 0.5 : 0.0);
            double y = pos.m_82450_().f_82480_ - (side == 0 ? 2.0 : 0.0) + (side == 1 ? 0.5 : 0.0);
            double z = pos.m_82450_().f_82481_ - (side == 2 ? 0.5 : 0.0) + (side == 3 ? 0.5 : 0.0);
            player.m_8127_();
            ((ServerPlayer)player).f_8906_.m_9774_(x, y, z, player.f_19859_, player.f_19860_);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_blink.line1").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_blink.line2").m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_blink.line3").m_130940_(ChatFormatting.RED));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring.cooldown", new Object[]{this.blinkCooldown}).m_130940_(ChatFormatting.LIGHT_PURPLE));
    }
}

