/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomArmorDragon
extends ArmorItem {
    boolean enablePerks = (Boolean)GobberConfigBuilder.ENABLE_GOBBER_DRAGON_ARMOR_HEALTH_PERKS.get();
    int hunger = (Integer)GobberConfigBuilder.GOBBER_DRAGON_ARMOR_HUNGER.get();
    double saturation = (Double)GobberConfigBuilder.GOBBER_DRAGON_ARMOR_SATURATION.get();
    boolean autofeed = (Boolean)GobberConfigBuilder.ENABLE_GOBBER_DRAGON_ARMOR_AUTOFEED.get();
    boolean flight = (Boolean)GobberConfigBuilder.ENABLE_GOBBER_DRAGON_ARMOR_FLIGHT.get();
    boolean yellowHearts = (Boolean)GobberConfigBuilder.ENABLE_GOBBER_DRAGON_ARMOR_YELLOW_HEARTS_PERKS.get();

    public ItemCustomArmorDragon(ArmorMaterial materialIn, EquipmentSlot slots, Item.Properties builder) {
        super(materialIn, slots, builder);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = player.m_6844_(EquipmentSlot.FEET);
        if (head.m_41720_() == ItemInit.GOBBER2_HELMET_DRAGON.get()) {
            this.setDamage(head, 0);
        }
        if (chest.m_41720_() == ItemInit.GOBBER2_CHESTPLATE_DRAGON.get()) {
            this.setDamage(chest, 0);
        }
        if (legs.m_41720_() == ItemInit.GOBBER2_LEGGINGS_DRAGON.get()) {
            this.setDamage(legs, 0);
        }
        if (feet.m_41720_() == ItemInit.GOBBER2_BOOTS_DRAGON.get()) {
            this.setDamage(feet, 0);
        }
        if (!this.enablePerks) {
            return;
        }
        if (!player.getPersistentData().m_128441_("wearingFullDragonArmor")) {
            player.getPersistentData().m_128379_("wearingFullDragonArmor", false);
        }
        boolean iswearingFullDragonArmor = head != null && head.m_41720_() == ItemInit.GOBBER2_HELMET_DRAGON.get() && chest != null && chest.m_41720_() == ItemInit.GOBBER2_CHESTPLATE_DRAGON.get() && legs != null && legs.m_41720_() == ItemInit.GOBBER2_LEGGINGS_DRAGON.get() && feet != null && feet.m_41720_() == ItemInit.GOBBER2_BOOTS_DRAGON.get();
        boolean wasWearingDragonArmorLastTick = player.getPersistentData().m_128471_("wearingFullDragonArmor");
        if (this.flight) {
            if (!iswearingFullDragonArmor && wasWearingDragonArmorLastTick && !player.m_7500_()) {
                player.m_150110_().f_35936_ = false;
                player.m_150110_().f_35935_ = false;
            } else if (iswearingFullDragonArmor && (world.m_46472_().equals((Object)Level.f_46428_) || world.m_46472_().equals((Object)Level.f_46429_) || world.m_46472_().equals((Object)Level.f_46430_))) {
                player.m_150110_().f_35936_ = true;
            }
            player.getPersistentData().m_128379_("wearingFullDragonArmor", iswearingFullDragonArmor);
        }
        if (iswearingFullDragonArmor) {
            if (player.m_21124_(MobEffects.f_19610_) != null) {
                player.m_21195_(MobEffects.f_19610_);
            }
            if (player.m_21124_(MobEffects.f_19597_) != null) {
                player.m_21195_(MobEffects.f_19597_);
            }
            if (player.m_21124_(MobEffects.f_19599_) != null) {
                player.m_21195_(MobEffects.f_19599_);
            }
            if (player.m_21124_(MobEffects.f_19602_) != null) {
                player.m_21195_(MobEffects.f_19602_);
            }
            if (player.m_21124_(MobEffects.f_19604_) != null) {
                player.m_21195_(MobEffects.f_19604_);
            }
            if (player.m_21124_(MobEffects.f_19612_) != null) {
                player.m_21195_(MobEffects.f_19612_);
            }
            if (player.m_21124_(MobEffects.f_19614_) != null) {
                player.m_21195_(MobEffects.f_19614_);
            }
            if (player.m_21124_(MobEffects.f_19615_) != null) {
                player.m_21195_(MobEffects.f_19615_);
            }
            if (player.m_21124_(MobEffects.f_19620_) != null) {
                player.m_21195_(MobEffects.f_19620_);
            }
            if (player.m_21124_(MobEffects.f_19590_) != null) {
                player.m_21195_(MobEffects.f_19590_);
            }
            if (player.m_21124_(MobEffects.f_19613_) != null) {
                player.m_21195_(MobEffects.f_19613_);
            }
        }
        if (head.m_41720_() == ItemInit.GOBBER2_HELMET_DRAGON.get()) {
            if (this.yellowHearts) {
                PlayerSpecialAbilities.giveYellowHearts(world, (LivingEntity)player, stack, 20, 0.66f);
            }
            if (this.autofeed) {
                PlayerSpecialAbilities.giveRegenEffect(world, player, stack, this.hunger, (float)this.saturation);
            }
        } else {
            PlayerSpecialAbilities.giveNoExtraHearts(world, player, stack);
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        stack.m_41784_().m_128379_("Unbreakable", true);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_41720_() == ItemInit.GOBBER2_INGOT_END.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_armor_dragon.line1").m_130940_(ChatFormatting.LIGHT_PURPLE));
        if (this.enablePerks && this.flight) {
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_armor_dragon.line2").m_130940_(ChatFormatting.GOLD));
        }
        if (this.enablePerks && !this.flight) {
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_armor_dragon.line3").m_130940_(ChatFormatting.GOLD));
        }
    }
}

