/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util.handlers;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.util.PlayerEquipsUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gobber2", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    static int extraXPOrbs = (Integer)GobberConfigBuilder.MEDALLION_EXP_ORBS.get();
    static int extraLoot = (Integer)GobberConfigBuilder.MEDALLION_EXP_LOOT.get();
    static boolean enableVoidProtection = (Boolean)GobberConfigBuilder.ENABLE_DRAGON_ARMOR_VOID_PROTECTION.get();

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void onLivingHurtEvent(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (enableVoidProtection && event.getSource() == DamageSource.f_19317_ && PlayerEquipsUtil.isPlayerGotVoidProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event.getSource() == DamageSource.f_19315_ && PlayerEquipsUtil.isPlayerGotFallProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if ((event.getSource() == DamageSource.f_19305_ || event.getSource() == DamageSource.f_19307_ || event.getSource() == DamageSource.f_19308_) && PlayerEquipsUtil.isPlayerGotFireProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event.getSource() == DamageSource.f_19312_ && PlayerEquipsUtil.isPlayerGotWaterBreathing(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof Player && event.getEntity() instanceof Mob) {
            Player player = (Player)event.getTarget();
            Mob attacker = (Mob)event.getEntity();
            if (PlayerEquipsUtil.isPlayerGotStealth(player)) {
                attacker.m_6710_(null);
            }
        }
    }

    @SubscribeEvent
    public static void onKillingLootEvent(LootingLevelEvent event) {
        Player player;
        if (event.getDamageSource() != null && event.getDamageSource().m_7639_() != null && event.getEntity() instanceof Mob && event.getDamageSource().m_7639_() instanceof Player && PlayerEquipsUtil.isPlayerGotExpToken(player = (Player)event.getDamageSource().m_7639_())) {
            event.setLootingLevel(extraLoot);
        }
    }

    @SubscribeEvent
    public static void onKillingExpDropEvent(LivingExperienceDropEvent event) {
        Player player;
        if (event.getAttackingPlayer() instanceof Player && event.getEntity() instanceof Mob && PlayerEquipsUtil.isPlayerGotExpToken(player = event.getAttackingPlayer())) {
            int orgExp = event.getOriginalExperience();
            int newExp = orgExp * extraXPOrbs;
            event.setDroppedExperience(newExp);
        }
    }

    @SubscribeEvent
    public static void onMiningExpDropEvent(BlockEvent.BreakEvent event) {
        Player player;
        Block block = event.getState().m_60734_();
        if ((block == Blocks.f_50173_ || block == Blocks.f_49997_ || block == Blocks.f_50059_ || block == Blocks.f_50089_ || block == Blocks.f_50264_ || block == Blocks.f_50331_) && event.getPlayer() instanceof Player && PlayerEquipsUtil.isPlayerGotExpToken(player = event.getPlayer()) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_()) == 0) {
            event.setExpToDrop(extraXPOrbs);
        }
    }
}

